/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jmol.api.SC;
import org.jmol.awt.AwtSwingComponent;
import org.jmol.popup.GenericPopup;
import org.jmol.popup.PopupHelper;

public class AwtPopupHelper
implements ActionListener,
ItemListener,
MouseListener,
PopupHelper {
    private GenericPopup popup;
    private Map<Object, SC> htSources = new Hashtable<Object, SC>();
    private ButtonGroup buttonGroup;

    public AwtPopupHelper(GenericPopup genericPopup) {
        this.popup = genericPopup;
    }

    @Override
    public SC menuCreatePopup(String string, Object object) {
        return AwtSwingComponent.getPopup(string, this.htSources);
    }

    @Override
    public SC getRadio(String string) {
        return AwtSwingComponent.getRadio(this, string, this.htSources);
    }

    @Override
    public SC getCheckBox(String string) {
        return AwtSwingComponent.getCheckBox(this, string, this.htSources);
    }

    @Override
    public SC getMenu(String string) {
        return AwtSwingComponent.getMenu(string, this.htSources);
    }

    @Override
    public SC getMenuItem(String string) {
        return AwtSwingComponent.getMenuItem(this, string, this.htSources);
    }

    @Override
    public void menuAddButtonGroup(SC sC) {
        if (sC == null) {
            if (this.buttonGroup != null && this.buttonGroup.getButtonCount() > 0) {
                this.buttonGroup = null;
            }
            return;
        }
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        this.buttonGroup.add(((AwtSwingComponent)sC).ab);
    }

    @Override
    public Object getButtonGroup() {
        return this.buttonGroup;
    }

    @Override
    public void menuInsertSubMenu(SC sC, SC sC2, int n) {
        sC.insert(sC2, n);
    }

    @Override
    public int getItemType(SC sC) {
        if (sC == null) {
            return 0;
        }
        JComponent jComponent = ((AwtSwingComponent)sC).jc;
        return jComponent instanceof JMenu ? 4 : (jComponent instanceof JRadioButtonMenuItem ? 3 : (jComponent instanceof JCheckBoxMenuItem ? 2 : (sC.getText() != null ? 1 : 0)));
    }

    @Override
    public SC getSwingComponent(Object object) {
        return object == null ? null : this.htSources.get(object);
    }

    @Override
    public void menuClearListeners(SC sC) {
        if (sC == null) {
            return;
        }
        this.clearListeners(sC.getComponents());
        this.clearListener(((AwtSwingComponent)sC).ab);
    }

    private void clearListener(AbstractButton abstractButton) {
        if (abstractButton != null) {
            try {
                abstractButton.removeMouseListener(this);
                abstractButton.removeActionListener(this);
                abstractButton.removeItemListener(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearListeners(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            JComponent jComponent = (JComponent)objectArray[n];
            if (jComponent instanceof JMenu) {
                this.clearListeners(jComponent.getComponents());
            }
            ++n;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.popup.menuCheckBoxCallback(this.getSource(itemEvent));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.popup.menuClickCallback(this.getSource(actionEvent), actionEvent.getActionCommand());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)mouseEvent.getSource();
            this.popup.menuFocusCallback(jMenuItem.getName(), jMenuItem.getActionCommand(), true);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)mouseEvent.getSource();
            this.popup.menuFocusCallback(jMenuItem.getName(), jMenuItem.getActionCommand(), false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private SC getSource(EventObject eventObject) {
        return this.getSwingComponent(eventObject.getSource());
    }

    public void reinstateMenu(JMenuItem jMenuItem, MenuElement[] menuElementArray) {
        String string = jMenuItem.getName();
        if (string.indexOf("Persist") >= 0 && string.indexOf("!Persist") < 0) {
            this.popup.jpiShow(this.popup.thisx, this.popup.thisy);
            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
        }
    }

    @Override
    public void dispose(SC sC) {
        this.menuClearListeners(sC);
        this.popup = null;
    }
}

