/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.context;

import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import java.util.Date;

public class FileOptions {
    public static final String DEFAULT_MODE = "644";
    private long fileTime = new Date().getTime();
    private String mode = "644";
    private OverwriteMode overwriteMode = OverwriteMode.ALWAYS_ASK_EXCEPT_FOR_UPDATE;
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private boolean delayIfNecessary = false;

    public FileOptions() {
    }

    public FileOptions(String mode, OverwriteMode overwriteMode, boolean shared) {
        this.mode = mode;
        this.overwriteMode = overwriteMode;
        this.shared = shared;
    }

    public FileOptions(long fileTime) {
        this.setFileTime(fileTime);
    }

    public FileOptions(long fileTime, OverwriteMode overwriteMode) {
        this.setFileTime(fileTime);
        this.overwriteMode = overwriteMode;
    }

    public FileOptions(long fileTime, String mode, OverwriteMode overwriteMode, boolean shared, UninstallMode uninstallMode) {
        this.setFileTime(fileTime);
        this.mode = mode;
        this.overwriteMode = overwriteMode;
        this.shared = shared;
        this.uninstallMode = uninstallMode;
    }

    public FileOptions(long fileTime, String mode, OverwriteMode overwriteMode, boolean shared, boolean delayIfNecessary, UninstallMode uninstallMode) {
        this.setFileTime(fileTime);
        this.mode = mode;
        this.overwriteMode = overwriteMode;
        this.shared = shared;
        this.delayIfNecessary = delayIfNecessary;
        this.uninstallMode = uninstallMode;
    }

    public FileOptions(OverwriteMode overwriteMode, UninstallMode uninstallMode) {
        this.overwriteMode = overwriteMode;
        this.uninstallMode = uninstallMode;
    }

    public long getFileTime() {
        return this.fileTime;
    }

    public void setFileTime(long fileTime) {
        if (fileTime > 0L) {
            this.fileTime = fileTime;
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(int intMode) {
        this.mode = Integer.toOctalString(intMode & 0x1FF);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public OverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public UninstallMode getUninstallMode() {
        return this.uninstallMode;
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    public boolean isDelayIfNecessary() {
        return this.delayIfNecessary;
    }

    public void setDelayIfNecessary(boolean delayIfNecessary) {
        this.delayIfNecessary = delayIfNecessary;
    }

    public String toString() {
        return "fileTime: " + new Date(this.fileTime) + ", mode: " + this.mode + ", overwriteMode: " + (Object)((Object)this.overwriteMode) + ", shared: " + this.shared + ", uninstallMode: " + (Object)((Object)this.uninstallMode) + ", delayIfNecessary: " + this.delayIfNecessary;
    }
}

