/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.runtime.installer.platform.win32.FileAssociations;
import java.io.File;

public class WinAssociations {
    public static void create(String extension, String description, File iconFile, File executable) {
        try {
            FileAssociations.create(extension, description, iconFile, executable, null);
        }
        catch (UserCanceledException userCanceledException) {
            // empty catch block
        }
    }

    public static boolean exists(String extension) {
        return FileAssociations.exists(extension, RegistryRoot.HKEY_CURRENT_USER) || FileAssociations.exists(extension, RegistryRoot.HKEY_CLASSES_ROOT);
    }

    public static String getExecutable(String extension) {
        String executable = FileAssociations.getExecutable(extension, RegistryRoot.HKEY_CURRENT_USER);
        if (executable != null) {
            return executable;
        }
        return FileAssociations.getExecutable(extension, RegistryRoot.HKEY_CLASSES_ROOT);
    }

    public static void remove(String extension) {
        try {
            FileAssociations.remove(extension, RegistryRoot.HKEY_CURRENT_USER, true);
            FileAssociations.remove(extension, RegistryRoot.HKEY_CLASSES_ROOT, true);
        }
        catch (UserCanceledException e) {
            e.printStackTrace();
        }
    }

    private WinAssociations() {
    }
}

