/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import mediathek.daten.DatenDownload;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.TimedTextMarkupLanguageParser;
import mediathek.tool.http.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MVSubtitle {
    private static final String SUFFIX_SRT = "srt";
    private static final String SUFFIX_TTML = "ttml";
    private static final String SUFFIX_VTT = "vtt";
    private static final Logger logger = LogManager.getLogger(MVSubtitle.class);

    private void createDirectory(String targetDirectory) {
        try {
            Files.createDirectory(Paths.get(targetDirectory, new String[0]), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeNetworkData(@NotNull BufferedSource bufferedSource, @NotNull Path ttmlPath) throws IOException {
        try (Sink fileSink = Okio.sink(ttmlPath, new OpenOption[0]);
             BufferedSink bufferedSink = Okio.buffer(fileSink);){
            bufferedSink.writeAll(bufferedSource);
            logger.trace("Untertitel-Datei wurde geschrieben");
        }
    }

    public void writeSubtitle(@NotNull String url, @NotNull File file) throws IOException {
        block21: {
            if (url.isEmpty()) {
                return;
            }
            String plainFileName = GuiFunktionen.getFileNameWithoutSuffix(file.getAbsolutePath());
            Request request = new Request.Builder().url(url).get().build();
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (response.isSuccessful()) {
                    logger.trace("Untertitel {} schreiben nach {}", (Object)url, (Object)plainFileName);
                    try (BufferedSource source2 = body.source();){
                        String suffix = GuiFunktionen.getSuffixFromUrl(url);
                        if (!suffix.endsWith(SUFFIX_SRT) && !suffix.endsWith(SUFFIX_VTT)) {
                            suffix = SUFFIX_TTML;
                        }
                        String strSubtitleFile = plainFileName + "." + suffix;
                        Path ttmlPath = Paths.get(strSubtitleFile, new String[0]);
                        this.writeNetworkData(source2, ttmlPath);
                        this.convertSubtitle(ttmlPath);
                        break block21;
                    }
                }
                logger.error("HTTP Response Code {} for URL: {}", (Object)response.code(), (Object)url);
            }
        }
    }

    public void writeSubtitle(@NotNull DatenDownload datenDownload) {
        block23: {
            String urlSubtitle = datenDownload.arr[23];
            if (urlSubtitle.isEmpty()) {
                return;
            }
            String targetDirectory = datenDownload.arr[30];
            Request request = new Request.Builder().url(urlSubtitle).get().build();
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (response.isSuccessful()) {
                    logger.trace("Untertitel {} schreiben nach {}", (Object)urlSubtitle, (Object)targetDirectory);
                    try (BufferedSource source2 = body.source();){
                        String suffix = GuiFunktionen.getSuffixFromUrl(urlSubtitle);
                        if (!suffix.endsWith(SUFFIX_SRT) && !suffix.endsWith(SUFFIX_VTT)) {
                            suffix = SUFFIX_TTML;
                        }
                        this.createDirectory(targetDirectory);
                        String strSubtitleFile = datenDownload.getFileNameWithoutSuffix() + "." + suffix;
                        Path ttmlPath = Paths.get(strSubtitleFile, new String[0]);
                        this.writeNetworkData(source2, ttmlPath);
                        this.convertSubtitle(ttmlPath);
                        break block23;
                    }
                }
                logger.error("HTTP Response Code {} for URL: {}", (Object)response.code(), (Object)urlSubtitle);
            }
            catch (IOException ex) {
                logger.error("Subtitle exception occured:", (Throwable)ex);
            }
        }
    }

    private void convertSubtitle(@NotNull Path ttmlPath) {
        String subtitleFileStr = GuiFunktionen.getFileNameWithoutSuffix(ttmlPath.toAbsolutePath().toString());
        try (TimedTextMarkupLanguageParser parser = new TimedTextMarkupLanguageParser();){
            if (!subtitleFileStr.endsWith(".srt") && !subtitleFileStr.endsWith(".vtt")) {
                Path srt = Paths.get(subtitleFileStr + ".srt", new String[0]);
                if (parser.parse(ttmlPath)) {
                    parser.toSrt(srt);
                } else if (parser.parseXmlFlash(ttmlPath)) {
                    parser.toSrt(srt);
                }
                logger.info("Untertitel-Datei wurde konvertiert.");
            }
        }
        catch (Exception ex) {
            logger.error("Fehler bei Untertitel schreiben:", (Throwable)ex);
        }
    }
}

