/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.javaagent;

import java.lang.instrument.Instrumentation;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.opensearch.javaagent.FileInterceptor;
import org.opensearch.javaagent.RuntimeHaltInterceptor;
import org.opensearch.javaagent.SocketChannelInterceptor;
import org.opensearch.javaagent.StackCallerClassChainExtractor;
import org.opensearch.javaagent.StackCallerProtectionDomainChainExtractor;
import org.opensearch.javaagent.SystemExitInterceptor;
import org.opensearch.javaagent.bootstrap.AgentPolicy;

public class Agent {
    private static final String[] INTERCEPTED_METHODS = new String[]{"write", "createFile", "createDirectories", "createLink", "copy", "move", "newByteChannel", "delete", "deleteIfExists", "read", "open"};

    private Agent() {
    }

    public static void premain(String agentArguments, Instrumentation instrumentation) throws Exception {
        Agent.initAgent(instrumentation);
    }

    public static void agentmain(String agentArguments, Instrumentation instrumentation) throws Exception {
        Agent.initAgent(instrumentation);
    }

    private static AgentBuilder createAgentBuilder() throws Exception {
        ElementMatcher.Junction socketType = ElementMatchers.isSubTypeOf(SocketChannel.class).or((ElementMatcher)ElementMatchers.isSubTypeOf(Socket.class));
        ElementMatcher.Junction pathType = ElementMatchers.isSubTypeOf(Files.class);
        ElementMatcher.Junction fileChannelType = ElementMatchers.isSubTypeOf(FileChannel.class);
        ElementMatcher.Junction fileSystemProviderType = ElementMatchers.isSubTypeOf(FileSystemProvider.class);
        AgentBuilder.Transformer socketTransformer = (b, typeDescription, classLoader, module, pd) -> b.visit((AsmVisitorWrapper)Advice.to(SocketChannelInterceptor.class).on((ElementMatcher)ElementMatchers.named((String)"connect").and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()))));
        AgentBuilder.Transformer fileTransformer = (b, typeDescription, classLoader, module, pd) -> b.visit((AsmVisitorWrapper)Advice.to(FileInterceptor.class).on((ElementMatcher)ElementMatchers.namedOneOf((String[])INTERCEPTED_METHODS).or((ElementMatcher)ElementMatchers.isAbstract())));
        ClassInjector.UsingUnsafe.ofBootLoader().inject(Map.of(new TypeDescription.ForLoadedType(StackCallerProtectionDomainChainExtractor.class), ClassFileLocator.ForClassLoader.read(StackCallerProtectionDomainChainExtractor.class), new TypeDescription.ForLoadedType(StackCallerClassChainExtractor.class), ClassFileLocator.ForClassLoader.read(StackCallerClassChainExtractor.class), new TypeDescription.ForLoadedType(AgentPolicy.class), ClassFileLocator.ForClassLoader.read(AgentPolicy.class)));
        ByteBuddy byteBuddy = new ByteBuddy().with((Implementation.Context.Factory)Implementation.Context.Disabled.Factory.INSTANCE);
        return new AgentBuilder.Default(byteBuddy).with((AgentBuilder.InitializationStrategy)AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.RedefinitionStrategy.REDEFINITION).with((AgentBuilder.TypeStrategy)AgentBuilder.TypeStrategy.Default.REDEFINE).ignore((ElementMatcher)ElementMatchers.nameContains((String)"$MockitoMock$")).type((ElementMatcher)socketType).transform(socketTransformer).type((ElementMatcher)pathType.or((ElementMatcher)fileChannelType).or((ElementMatcher)fileSystemProviderType)).transform(fileTransformer).type((ElementMatcher)ElementMatchers.is(System.class)).transform((b, typeDescription, classLoader, module, pd) -> b.visit((AsmVisitorWrapper)Advice.to(SystemExitInterceptor.class).on((ElementMatcher)ElementMatchers.named((String)"exit")))).type((ElementMatcher)ElementMatchers.is(Runtime.class)).transform((b, typeDescription, classLoader, module, pd) -> b.visit((AsmVisitorWrapper)Advice.to(RuntimeHaltInterceptor.class).on((ElementMatcher)ElementMatchers.named((String)"halt"))));
    }

    private static void initAgent(Instrumentation instrumentation) throws Exception {
        AgentBuilder agentBuilder = Agent.createAgentBuilder();
        agentBuilder.installOn(instrumentation);
    }
}

