/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.grok.Grok;
import org.opensearch.grok.MatcherWatchdog;
import org.opensearch.ingest.DropProcessor;
import org.opensearch.ingest.PipelineProcessor;
import org.opensearch.ingest.Processor;
import org.opensearch.ingest.common.AppendProcessor;
import org.opensearch.ingest.common.BytesProcessor;
import org.opensearch.ingest.common.CommunityIdProcessor;
import org.opensearch.ingest.common.ConvertProcessor;
import org.opensearch.ingest.common.CopyProcessor;
import org.opensearch.ingest.common.CsvProcessor;
import org.opensearch.ingest.common.DateIndexNameProcessor;
import org.opensearch.ingest.common.DateProcessor;
import org.opensearch.ingest.common.DissectProcessor;
import org.opensearch.ingest.common.DotExpanderProcessor;
import org.opensearch.ingest.common.FailProcessor;
import org.opensearch.ingest.common.FingerprintProcessor;
import org.opensearch.ingest.common.ForEachProcessor;
import org.opensearch.ingest.common.GrokProcessor;
import org.opensearch.ingest.common.GrokProcessorGetAction;
import org.opensearch.ingest.common.GsubProcessor;
import org.opensearch.ingest.common.HtmlStripProcessor;
import org.opensearch.ingest.common.JoinProcessor;
import org.opensearch.ingest.common.JsonProcessor;
import org.opensearch.ingest.common.KeyValueProcessor;
import org.opensearch.ingest.common.LowercaseProcessor;
import org.opensearch.ingest.common.RemoveByPatternProcessor;
import org.opensearch.ingest.common.RemoveProcessor;
import org.opensearch.ingest.common.RenameProcessor;
import org.opensearch.ingest.common.ScriptProcessor;
import org.opensearch.ingest.common.SetProcessor;
import org.opensearch.ingest.common.SortProcessor;
import org.opensearch.ingest.common.SplitProcessor;
import org.opensearch.ingest.common.TrimProcessor;
import org.opensearch.ingest.common.URLDecodeProcessor;
import org.opensearch.ingest.common.UppercaseProcessor;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;

public class IngestCommonModulePlugin
extends Plugin
implements ActionPlugin,
IngestPlugin {
    static final Setting<List<String>> PROCESSORS_ALLOWLIST_SETTING = Setting.listSetting((String)"ingest.common.processors.allowed", List.of(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> WATCHDOG_INTERVAL = Setting.timeSetting((String)"ingest.grok.watchdog.interval", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> WATCHDOG_MAX_EXECUTION_TIME = Setting.timeSetting((String)"ingest.grok.watchdog.max_execution_time", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        HashMap<String, Processor.Factory> processors = new HashMap<String, Processor.Factory>();
        processors.put("date", new DateProcessor.Factory(parameters.scriptService));
        processors.put("set", new SetProcessor.Factory(parameters.scriptService));
        processors.put("append", new AppendProcessor.Factory(parameters.scriptService));
        processors.put("rename", new RenameProcessor.Factory(parameters.scriptService));
        processors.put("remove", new RemoveProcessor.Factory(parameters.scriptService));
        processors.put("split", new SplitProcessor.Factory());
        processors.put("join", new JoinProcessor.Factory());
        processors.put("uppercase", new UppercaseProcessor.Factory());
        processors.put("lowercase", new LowercaseProcessor.Factory());
        processors.put("trim", new TrimProcessor.Factory());
        processors.put("convert", new ConvertProcessor.Factory());
        processors.put("gsub", new GsubProcessor.Factory());
        processors.put("fail", new FailProcessor.Factory(parameters.scriptService));
        processors.put("foreach", new ForEachProcessor.Factory(parameters.scriptService));
        processors.put("date_index_name", new DateIndexNameProcessor.Factory(parameters.scriptService));
        processors.put("sort", new SortProcessor.Factory());
        processors.put("grok", new GrokProcessor.Factory(Grok.BUILTIN_PATTERNS, IngestCommonModulePlugin.createGrokThreadWatchdog(parameters)));
        processors.put("script", new ScriptProcessor.Factory(parameters.scriptService));
        processors.put("dot_expander", new DotExpanderProcessor.Factory());
        processors.put("json", new JsonProcessor.Factory());
        processors.put("kv", new KeyValueProcessor.Factory(parameters.scriptService));
        processors.put("urldecode", new URLDecodeProcessor.Factory());
        processors.put("bytes", new BytesProcessor.Factory());
        processors.put("pipeline", (Processor.Factory)new PipelineProcessor.Factory(parameters.ingestService));
        processors.put("dissect", new DissectProcessor.Factory());
        processors.put("drop", (Processor.Factory)new DropProcessor.Factory());
        processors.put("html_strip", new HtmlStripProcessor.Factory());
        processors.put("csv", new CsvProcessor.Factory());
        processors.put("copy", new CopyProcessor.Factory(parameters.scriptService));
        processors.put("remove_by_pattern", new RemoveByPatternProcessor.Factory());
        processors.put("community_id", new CommunityIdProcessor.Factory());
        processors.put("fingerprint", new FingerprintProcessor.Factory());
        return this.filterForAllowlistSetting(parameters.env.settings(), processors);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)GrokProcessorGetAction.INSTANCE, GrokProcessorGetAction.TransportAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.singletonList(new GrokProcessorGetAction.RestAction());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(WATCHDOG_INTERVAL, WATCHDOG_MAX_EXECUTION_TIME, PROCESSORS_ALLOWLIST_SETTING);
    }

    private static MatcherWatchdog createGrokThreadWatchdog(Processor.Parameters parameters) {
        long intervalMillis = ((TimeValue)WATCHDOG_INTERVAL.get(parameters.env.settings())).getMillis();
        long maxExecutionTimeMillis = ((TimeValue)WATCHDOG_MAX_EXECUTION_TIME.get(parameters.env.settings())).getMillis();
        return MatcherWatchdog.newInstance((long)intervalMillis, (long)maxExecutionTimeMillis, (LongSupplier)parameters.relativeTimeSupplier, parameters.scheduler::apply);
    }

    private Map<String, Processor.Factory> filterForAllowlistSetting(Settings settings, Map<String, Processor.Factory> map) {
        if (!PROCESSORS_ALLOWLIST_SETTING.exists(settings)) {
            return Map.copyOf(map);
        }
        Set allowlist = Set.copyOf((Collection)PROCESSORS_ALLOWLIST_SETTING.get(settings));
        Set unknownAllowlistProcessors = allowlist.stream().filter(p -> !map.containsKey(p)).collect(Collectors.toUnmodifiableSet());
        if (!unknownAllowlistProcessors.isEmpty()) {
            throw new IllegalArgumentException("Processor(s) " + String.valueOf(unknownAllowlistProcessors) + " were defined in [" + PROCESSORS_ALLOWLIST_SETTING.getKey() + "] but do not exist");
        }
        return map.entrySet().stream().filter(e -> allowlist.contains(e.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

