/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccount;

public class GetIpamDiscoveredAccountsPublisher
implements SdkPublisher<GetIpamDiscoveredAccountsResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamDiscoveredAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamDiscoveredAccountsPublisher(Ec2AsyncClient client, GetIpamDiscoveredAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamDiscoveredAccountsPublisher(Ec2AsyncClient client, GetIpamDiscoveredAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamDiscoveredAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamDiscoveredAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamDiscoveredAccount> ipamDiscoveredAccounts() {
        Function<GetIpamDiscoveredAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamDiscoveredAccounts() != null) {
                return response.ipamDiscoveredAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetIpamDiscoveredAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetIpamDiscoveredAccountsResponseFetcher
    implements AsyncPageFetcher<GetIpamDiscoveredAccountsResponse> {
        private GetIpamDiscoveredAccountsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamDiscoveredAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamDiscoveredAccountsResponse> nextPage(GetIpamDiscoveredAccountsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamDiscoveredAccountsPublisher.this.client.getIpamDiscoveredAccounts(GetIpamDiscoveredAccountsPublisher.this.firstRequest);
            }
            return GetIpamDiscoveredAccountsPublisher.this.client.getIpamDiscoveredAccounts((GetIpamDiscoveredAccountsRequest)((Object)GetIpamDiscoveredAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

