/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;

public class LogTruncationException
extends OffsetOutOfRangeException {
    private final Map<TopicPartition, OffsetAndMetadata> divergentOffsets;

    public LogTruncationException(Map<TopicPartition, Long> fetchOffsets, Map<TopicPartition, OffsetAndMetadata> divergentOffsets) {
        this("Truncated partitions detected with divergent offsets " + divergentOffsets, fetchOffsets, divergentOffsets);
    }

    public LogTruncationException(String message, Map<TopicPartition, Long> fetchOffsets, Map<TopicPartition, OffsetAndMetadata> divergentOffsets) {
        super(message, fetchOffsets);
        this.divergentOffsets = Collections.unmodifiableMap(divergentOffsets);
    }

    public Map<TopicPartition, OffsetAndMetadata> divergentOffsets() {
        return this.divergentOffsets;
    }
}

