/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.setting;

import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.setting.OpensearchDynamicSetting;

public class TransportPassiveAuthSetting
extends OpensearchDynamicSetting<Boolean> {
    private static final String SETTING = "plugins.security.unsupported.passive_intertransport_auth_initially";

    public TransportPassiveAuthSetting(Settings settings) {
        super(TransportPassiveAuthSetting.getSetting(), TransportPassiveAuthSetting.getSettingInitialValue(settings));
    }

    private static Setting<Boolean> getSetting() {
        return Setting.boolSetting((String)SETTING, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    }

    private static Boolean getSettingInitialValue(Settings settings) {
        return settings.getAsBoolean(SETTING, Boolean.valueOf(false));
    }

    @Override
    protected String getClusterChangeMessage(Boolean dynamicSettingNewValue) {
        return String.format("Detected change in settings, cluster setting for transportPassiveAuth is %s", dynamicSettingNewValue != false ? "enabled" : "disabled");
    }
}

