/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository;

import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;

public class TransferEvent
extends IvyEvent {
    private Resource resource;
    private int eventType;
    private int requestType;
    private Exception exception;
    private Repository repository;
    private long length;
    private long totalLength;
    private boolean isTotalLengthSet = false;
    private long[] timeTracking = new long[5];

    public TransferEvent(Repository repository, Resource resource, int n, int n2) {
        super(TransferEvent.getName(n));
        this.repository = repository;
        this.setResource(resource);
        this.setEventType(n);
        this.setRequestType(n2);
    }

    private static String getName(int n) {
        switch (n) {
            case 0: {
                return "transfer-initiated";
            }
            case 1: {
                return "transfer-started";
            }
            case 3: {
                return "transfer-progress";
            }
            case 2: {
                return "transfer-completed";
            }
            case 4: {
                return "transfer-error";
            }
        }
        return null;
    }

    protected void setRequestType(int n) {
        switch (n) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type: " + n);
            }
        }
        this.requestType = n;
        this.addAttribute("request-type", n == 5 ? "get" : "put");
    }

    public int getEventType() {
        return this.eventType;
    }

    protected void setEventType(int n) {
        this.checkEventType(n);
        if (this.eventType != n) {
            this.eventType = n;
            this.timeTracking[n] = System.currentTimeMillis();
            if (n > 0) {
                this.addAttribute("total-duration", String.valueOf(this.getElapsedTime(0, n)));
                if (n > 1) {
                    this.addAttribute("duration", String.valueOf(this.getElapsedTime(1, n)));
                }
            }
        }
    }

    protected void setResource(Resource resource) {
        this.resource = resource;
        this.addAttribute("resource", this.resource.getName());
    }

    protected void setLength(long l) {
        this.length = l;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    protected void setTotalLength(long l) {
        this.totalLength = l;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isTotalLengthSet() {
        return this.isTotalLengthSet;
    }

    public void setTotalLengthSet(boolean bl) {
        this.isTotalLengthSet = bl;
    }

    public long getElapsedTime(int n, int n2) {
        this.checkEventType(n);
        this.checkEventType(n2);
        long l = this.timeTracking[n];
        long l2 = this.timeTracking[n2];
        if (l == 0L || l2 == 0L) {
            return -1L;
        }
        if (l2 < l) {
            return 0L;
        }
        return l2 - l;
    }

    private void checkEventType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid event type " + n);
        }
    }
}

