/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.Vector3;

public class LightSample {
    private Ray shadowRay = null;
    private Color ldiff = null;
    private Color lspec = null;
    LightSample next = null;

    boolean isValid() {
        return this.ldiff != null && this.lspec != null && this.shadowRay != null;
    }

    public void setShadowRay(Ray ray) {
        this.shadowRay = ray;
    }

    public final void traceShadow(ShadingState shadingState) {
        Color color = shadingState.traceShadow(this.shadowRay);
        Color.blend(this.ldiff, Color.BLACK, color, this.ldiff);
        Color.blend(this.lspec, Color.BLACK, color, this.lspec);
    }

    public Ray getShadowRay() {
        return this.shadowRay;
    }

    public Color getDiffuseRadiance() {
        return this.ldiff;
    }

    public Color getSpecularRadiance() {
        return this.lspec;
    }

    public void setRadiance(Color color, Color color2) {
        this.ldiff = color.copy();
        this.lspec = color2.copy();
    }

    public float dot(Vector3 vector3) {
        return this.shadowRay.dot(vector3);
    }
}

