/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.dict.TokenInfoDictionaryEntryWriter;
import org.apache.lucene.analysis.ko.dict.UnknownDictionary;
import org.apache.lucene.analysis.morph.BinaryDictionaryWriter;
import org.apache.lucene.analysis.morph.CharacterDefinitionWriter;
import org.apache.lucene.analysis.morph.DictionaryEntryWriter;

class UnknownDictionaryWriter
extends BinaryDictionaryWriter<UnknownDictionary> {
    private final CharacterDefinitionWriter<CharacterDefinition> characterDefinition = new CharacterDefinitionWriter(CharacterDefinition.class, CharacterDefinition.DEFAULT, CharacterDefinition.CLASS_COUNT, CharacterDefinition::lookupCharacterClass);

    public UnknownDictionaryWriter(int size) {
        super(UnknownDictionary.class, (DictionaryEntryWriter)new TokenInfoDictionaryEntryWriter(size));
    }

    public int put(String[] entry) {
        int wordId = this.entryWriter.currentPosition();
        int result = super.put(entry);
        byte characterId = CharacterDefinition.lookupCharacterClass(entry[0]);
        this.addMapping(characterId, wordId);
        return result;
    }

    public void putCharacterCategory(int codePoint, String characterClassName) {
        this.characterDefinition.putCharacterCategory(codePoint, characterClassName);
    }

    public void putInvokeDefinition(String characterClassName, int invoke, int group, int length) {
        this.characterDefinition.putInvokeDefinition(characterClassName, invoke, group, length);
    }

    public void write(Path baseDir) throws IOException {
        super.write(baseDir, "ko_dict_map", "ko_dict_pos", "ko_dict", 1);
        this.characterDefinition.write(baseDir, "ko_cd", 1);
    }
}

