/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.PrincipalIdFormat;

public class DescribePrincipalIdFormatIterable
implements SdkIterable<DescribePrincipalIdFormatResponse> {
    private final Ec2Client client;
    private final DescribePrincipalIdFormatRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePrincipalIdFormatIterable(Ec2Client client, DescribePrincipalIdFormatRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribePrincipalIdFormatResponseFetcher();
    }

    public Iterator<DescribePrincipalIdFormatResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrincipalIdFormat> principals() {
        Function<DescribePrincipalIdFormatResponse, Iterator> getIterator = response -> {
            if (response != null && response.principals() != null) {
                return response.principals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePrincipalIdFormatResponseFetcher
    implements SyncPageFetcher<DescribePrincipalIdFormatResponse> {
        private DescribePrincipalIdFormatResponseFetcher() {
        }

        public boolean hasNextPage(DescribePrincipalIdFormatResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePrincipalIdFormatResponse nextPage(DescribePrincipalIdFormatResponse previousPage) {
            if (previousPage == null) {
                return DescribePrincipalIdFormatIterable.this.client.describePrincipalIdFormat(DescribePrincipalIdFormatIterable.this.firstRequest);
            }
            return DescribePrincipalIdFormatIterable.this.client.describePrincipalIdFormat((DescribePrincipalIdFormatRequest)((Object)DescribePrincipalIdFormatIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

