/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.util.Message;

public final class IvyPatternHelper {
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\@\\{(.*?)\\}");
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    public static String substitute(String string, ModuleRevisionId moduleRevisionId) {
        return IvyPatternHelper.substitute(string, moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), "ivy", "ivy", "xml", null, null, moduleRevisionId.getQualifiedExtraAttributes(), null);
    }

    public static String substitute(String string, Artifact artifact) {
        return IvyPatternHelper.substitute(string, artifact, null);
    }

    public static String substitute(String string, Artifact artifact, ArtifactOrigin artifactOrigin) {
        return IvyPatternHelper.substitute(string, artifact.getModuleRevisionId(), artifact, null, artifactOrigin);
    }

    public static String substitute(String string, Artifact artifact, String string2) {
        return IvyPatternHelper.substitute(string, artifact.getModuleRevisionId(), artifact, string2, null);
    }

    public static String substitute(String string, ModuleRevisionId moduleRevisionId, Artifact artifact) {
        return IvyPatternHelper.substitute(string, moduleRevisionId, artifact, null, null);
    }

    public static String substitute(String string, ModuleRevisionId moduleRevisionId, Artifact artifact, String string2, ArtifactOrigin artifactOrigin) {
        return IvyPatternHelper.substitute(string, moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), artifact.getName(), artifact.getType(), artifact.getExt(), string2, artifactOrigin, moduleRevisionId.getQualifiedExtraAttributes(), artifact.getQualifiedExtraAttributes());
    }

    public static String substitute(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return IvyPatternHelper.substitute(string, string2, string3, null, string4, string5, string6, string7, null, null, null, null);
    }

    public static String substitute(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, ArtifactOrigin artifactOrigin, Map map, Map map2) {
        String string10;
        HashMap hashMap = new HashMap();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                string10 = (String)entry.getKey();
                if (string10.indexOf(58) > 0) {
                    String string11 = string10;
                    string10 = string11.substring(string11.indexOf(58) + 1);
                }
                hashMap.put(string10, entry.getValue());
            }
        }
        if (map2 != null) {
            for (Map.Entry entry : map2.entrySet()) {
                string10 = (String)entry.getKey();
                if (string10.indexOf(58) > 0) {
                    String string12 = string10;
                    string10 = string12.substring(string12.indexOf(58) + 1);
                }
                hashMap.put(string10, entry.getValue());
            }
        }
        hashMap.put("organisation", string2 == null ? "" : string2);
        hashMap.put("organization", string2 == null ? "" : string2);
        hashMap.put("orgPath", string2 == null ? "" : string2.replace('.', '/'));
        hashMap.put("module", string3 == null ? "" : string3);
        hashMap.put("branch", string4 == null ? "" : string4);
        hashMap.put("revision", string5 == null ? "" : string5);
        hashMap.put("artifact", string6 == null ? string3 : string6);
        hashMap.put("type", string7 == null ? "jar" : string7);
        hashMap.put("ext", string8 == null ? "jar" : string8);
        hashMap.put("conf", string9 == null ? "default" : string9);
        if (artifactOrigin == null) {
            hashMap.put("originalname", new OriginalArtifactNameValue(string2, string3, string4, string5, string6, string7, string8, map, map2));
        } else {
            hashMap.put("originalname", new OriginalArtifactNameValue(artifactOrigin));
        }
        return IvyPatternHelper.substituteTokens(string, hashMap);
    }

    public static String substituteVariables(String string, Map map) {
        return IvyPatternHelper.substituteVariables(string, new IvyVariableContainerImpl(map), new Stack());
    }

    public static String substituteVariables(String string, IvyVariableContainer ivyVariableContainer) {
        return IvyPatternHelper.substituteVariables(string, ivyVariableContainer, new Stack());
    }

    private static String substituteVariables(String object, IvyVariableContainer ivyVariableContainer, Stack stack) {
        if (object == null) {
            return null;
        }
        Matcher matcher = VAR_PATTERN.matcher((CharSequence)object);
        boolean bl = false;
        StringBuffer stringBuffer = null;
        while (matcher.find()) {
            String string;
            String string2;
            if (!bl) {
                bl = true;
                stringBuffer = new StringBuffer();
            }
            if ((string2 = ivyVariableContainer.getVariable(string = matcher.group(1))) != null) {
                int n = stack.indexOf(string);
                if (n != -1) {
                    object = new ArrayList<String>(stack.subList(n, stack.size()));
                    object.add(string);
                    throw new IllegalArgumentException("cyclic variable definition: cycle = " + object);
                }
                stack.push(string);
                string2 = IvyPatternHelper.substituteVariables(string2, ivyVariableContainer, stack);
                stack.pop();
            } else {
                string2 = matcher.group();
            }
            matcher.appendReplacement(stringBuffer, string2.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        }
        if (bl) {
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return object;
    }

    public static String substituteTokens(String string, Map hashMap) {
        CharSequence charSequence;
        if ((hashMap = new HashMap(hashMap)).containsKey("organisation") && !hashMap.containsKey("organization")) {
            hashMap.put("organization", hashMap.get("organisation"));
        }
        if (hashMap.containsKey("organisation") && !hashMap.containsKey("orgPath")) {
            charSequence = (String)hashMap.get("organisation");
            hashMap.put("orgPath", charSequence == null ? "" : ((String)charSequence).replace('.', '/'));
        }
        charSequence = new StringBuffer();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '(': {
                    if (bl) {
                        throw new IllegalArgumentException("invalid start of optional part at position " + i + " in pattern " + string);
                    }
                    stringBuffer = new StringBuffer();
                    bl = true;
                    bl3 = false;
                    bl4 = false;
                    continue block6;
                }
                case ')': {
                    if (!bl || bl2) {
                        throw new IllegalArgumentException("invalid end of optional part at position " + i + " in pattern " + string);
                    }
                    if (bl4) {
                        ((StringBuffer)charSequence).append(stringBuffer.toString());
                    } else if (!bl3) {
                        ((StringBuffer)charSequence).append('(').append(stringBuffer.toString()).append(')');
                    }
                    bl = false;
                    continue block6;
                }
                case '[': {
                    if (bl2) {
                        throw new IllegalArgumentException("invalid start of token at position " + i + " in pattern " + string);
                    }
                    stringBuffer2 = new StringBuffer();
                    bl2 = true;
                    continue block6;
                }
                case ']': {
                    if (!bl2) {
                        throw new IllegalArgumentException("invalid end of token at position " + i + " in pattern " + string);
                    }
                    String string2 = stringBuffer2.toString();
                    Object object = hashMap.get(string2);
                    String string3 = object = object == null ? null : object.toString();
                    if (bl) {
                        bl4 = object != null && ((String)object).length() > 0;
                        stringBuffer.append((String)object);
                    } else {
                        if (object == null) {
                            object = "[" + string2 + "]";
                        }
                        ((StringBuffer)charSequence).append((String)object);
                    }
                    bl2 = false;
                    bl3 = true;
                    continue block6;
                }
                default: {
                    if (bl2) {
                        stringBuffer2.append(cArray[i]);
                        continue block6;
                    }
                    if (bl) {
                        stringBuffer.append(cArray[i]);
                        continue block6;
                    }
                    ((StringBuffer)charSequence).append(cArray[i]);
                }
            }
        }
        if (bl2) {
            throw new IllegalArgumentException("last token hasn't been closed in pattern " + string);
        }
        if (bl) {
            throw new IllegalArgumentException("optional part hasn't been closed in pattern " + string);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String substituteToken(String charSequence, String string, String string2) {
        charSequence = new StringBuffer((String)charSequence);
        IvyPatternHelper.substituteToken((StringBuffer)charSequence, string, string2);
        return ((StringBuffer)charSequence).toString();
    }

    public static void substituteToken(StringBuffer stringBuffer, String string, String string2) {
        string = IvyPatternHelper.getTokenString(string);
        int n = string.length();
        int n2 = stringBuffer.indexOf(string);
        while (n2 != -1) {
            int n3 = n2;
            stringBuffer.replace(n3, n3 + n, string2);
            n2 = stringBuffer.indexOf(string, n2);
        }
    }

    public static String getTokenString(String string) {
        return "[" + string + "]";
    }

    public static String substituteParams(String string, Map map) {
        return IvyPatternHelper.substituteParams(string, new IvyVariableContainerImpl(map), new Stack());
    }

    private static String substituteParams(String arrayList, IvyVariableContainer ivyVariableContainer, Stack stack) {
        if (arrayList == null) {
            return null;
        }
        arrayList = PARAM_PATTERN.matcher((CharSequence)((Object)arrayList));
        StringBuffer stringBuffer = new StringBuffer();
        while (((Matcher)((Object)arrayList)).find()) {
            String string = ((Matcher)((Object)arrayList)).group(1);
            String string2 = ivyVariableContainer.getVariable(string);
            if (string2 != null) {
                int n = stack.indexOf(string);
                if (n != -1) {
                    arrayList = new ArrayList<String>(stack.subList(n, stack.size()));
                    arrayList.add(string);
                    throw new IllegalArgumentException("cyclic param definition: cycle = " + arrayList);
                }
                stack.push(string);
                string2 = IvyPatternHelper.substituteVariables(string2, ivyVariableContainer, stack);
                stack.pop();
            } else {
                string2 = ((Matcher)((Object)arrayList)).group();
            }
            ((Matcher)((Object)arrayList)).appendReplacement(stringBuffer, string2.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\@", "\\\\\\@"));
        }
        ((Matcher)((Object)arrayList)).appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String getTokenRoot(String string) {
        int n = string.indexOf(91);
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(40);
        if (n2 >= 0) {
            n = Math.min(n, n2);
        }
        return string.substring(0, n);
    }

    private static class OriginalArtifactNameValue {
        private String org;
        private String moduleName;
        private String branch;
        private String revision;
        private Map extraModuleAttributes;
        private String artifactName;
        private String artifactType;
        private String artifactExt;
        private Map extraArtifactAttributes;
        private ArtifactOrigin origin;

        public OriginalArtifactNameValue(String string, String string2, String string3, String string4, String string5, String string6, String string7, Map map, Map map2) {
            this.org = string;
            this.moduleName = string2;
            this.branch = string3;
            this.revision = string4;
            this.artifactName = string5;
            this.artifactType = string6;
            this.artifactExt = string7;
            this.extraModuleAttributes = map;
            this.extraArtifactAttributes = map2;
        }

        public OriginalArtifactNameValue(ArtifactOrigin artifactOrigin) {
            this.origin = artifactOrigin;
        }

        public String toString() {
            Object object;
            if (this.origin == null) {
                object = ModuleRevisionId.newInstance(this.org, this.moduleName, this.branch, this.revision, this.extraModuleAttributes);
                DefaultArtifact defaultArtifact = new DefaultArtifact((ModuleRevisionId)object, null, this.artifactName, this.artifactType, this.artifactExt, this.extraArtifactAttributes);
                RepositoryCacheManager repositoryCacheManager = IvyContext.getContext().getSettings().getResolver((ModuleRevisionId)object).getRepositoryCacheManager();
                this.origin = repositoryCacheManager.getSavedArtifactOrigin(defaultArtifact);
                if (ArtifactOrigin.isUnknown(this.origin)) {
                    Message.debug("no artifact origin found for " + defaultArtifact + " in " + repositoryCacheManager);
                    return null;
                }
            }
            if (ArtifactOrigin.isUnknown(this.origin)) {
                return null;
            }
            object = this.origin.getLocation();
            int n = ((String)object).lastIndexOf(47);
            if (n == -1) {
                n = ((String)object).lastIndexOf(92);
            }
            int n2 = ((String)object).lastIndexOf(46);
            return ((String)object).substring(n + 1, n2);
        }
    }
}

