/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

class BreakCycles
extends GraphVisitor {
    NodeList graphNodes = new NodeList();

    BreakCycles() {
    }

    private boolean allNodesFlagged() {
        return this.graphNodes.stream().noneMatch(n -> !n.flag);
    }

    private void breakCycles(DirectedGraph g) {
        this.initializeDegrees(g);
        this.greedyCycleRemove(g);
        BreakCycles.invertEdges(g);
    }

    private boolean containsCycles(DirectedGraph g) {
        ArrayList<Node> noLefts = new ArrayList<Node>();
        for (Node node : this.graphNodes) {
            if (BreakCycles.getIncomingCount(node) != 0) continue;
            BreakCycles.sortedInsert(noLefts, node);
        }
        while (!noLefts.isEmpty()) {
            Node node;
            node = (Node)noLefts.remove(noLefts.size() - 1);
            node.flag = true;
            for (Edge e : node.outgoing) {
                Node right = e.target;
                BreakCycles.setIncomingCount(right, BreakCycles.getIncomingCount(right) - 1);
                if (BreakCycles.getIncomingCount(right) != 0) continue;
                BreakCycles.sortedInsert(noLefts, right);
            }
        }
        return !this.allNodesFlagged();
    }

    private Node findNodeWithMaxDegree() {
        int max = Integer.MIN_VALUE;
        Node maxNode = null;
        for (Node node : this.graphNodes) {
            if (BreakCycles.getDegree(node) < max || node.flag) continue;
            max = BreakCycles.getDegree(node);
            maxNode = node;
        }
        return maxNode;
    }

    private static int getDegree(Node n) {
        return n.workingInts[3];
    }

    private static int getIncomingCount(Node n) {
        return n.workingInts[0];
    }

    private static int getInDegree(Node n) {
        return n.workingInts[1];
    }

    private static int getOrderIndex(Node n) {
        return n.workingInts[0];
    }

    private static int getOutDegree(Node n) {
        return n.workingInts[2];
    }

    private void greedyCycleRemove(DirectedGraph g) {
        NodeList sL = new NodeList();
        NodeList sR = new NodeList();
        while (true) {
            boolean hasSource;
            boolean hasSink = false;
            for (Node node : this.graphNodes) {
                if (BreakCycles.getOutDegree(node) != 0 || node.flag) continue;
                hasSink = true;
                node.flag = true;
                BreakCycles.updateIncoming(node);
                sR.add(node);
                break;
            }
            if (hasSink) continue;
            block2: do {
                hasSource = false;
                for (Node node : this.graphNodes) {
                    if (BreakCycles.getInDegree(node) != 0 || node.flag) continue;
                    hasSource = true;
                    node.flag = true;
                    BreakCycles.updateOutgoing(node);
                    sL.add(node);
                    continue block2;
                }
            } while (hasSource);
            Node max = this.findNodeWithMaxDegree();
            if (max != null) {
                sL.add(max);
                max.flag = true;
                BreakCycles.updateIncoming(max);
                BreakCycles.updateOutgoing(max);
            }
            if (this.allNodesFlagged()) break;
        }
        int orderIndex = 0;
        for (Node element : sL) {
            BreakCycles.setOrderIndex(element, orderIndex);
            ++orderIndex;
        }
        int i = sR.size() - 1;
        while (i >= 0) {
            BreakCycles.setOrderIndex((Node)sR.get(i), orderIndex);
            ++orderIndex;
            --i;
        }
    }

    private void initializeDegrees(DirectedGraph g) {
        this.graphNodes.resetFlags();
        int i = 0;
        while (i < g.nodes.size()) {
            Node n = (Node)this.graphNodes.get(i);
            BreakCycles.setInDegree(n, n.incoming.size());
            BreakCycles.setOutDegree(n, n.outgoing.size());
            BreakCycles.setDegree(n, n.outgoing.size() - n.incoming.size());
            ++i;
        }
    }

    private static void invertEdges(DirectedGraph g) {
        for (Edge e : g.edges) {
            if (BreakCycles.getOrderIndex(e.source) <= BreakCycles.getOrderIndex(e.target)) continue;
            e.invert();
            e.isFeedback = true;
        }
    }

    private static void setDegree(Node n, int deg) {
        n.workingInts[3] = deg;
    }

    private static void setIncomingCount(Node n, int count) {
        n.workingInts[0] = count;
    }

    private static void setInDegree(Node n, int deg) {
        n.workingInts[1] = deg;
    }

    private static void setOutDegree(Node n, int deg) {
        n.workingInts[2] = deg;
    }

    private static void setOrderIndex(Node n, int index) {
        n.workingInts[0] = index;
    }

    private static void sortedInsert(List<Node> list, Node node) {
        int insert = 0;
        while (insert < list.size() && list.get((int)insert).sortValue > node.sortValue) {
            ++insert;
        }
        list.add(insert, node);
    }

    private static void updateIncoming(Node n) {
        for (Edge e : n.incoming) {
            Node in = e.source;
            if (in.flag) continue;
            BreakCycles.setOutDegree(in, BreakCycles.getOutDegree(in) - 1);
            BreakCycles.setDegree(in, BreakCycles.getOutDegree(in) - BreakCycles.getInDegree(in));
        }
    }

    private static void updateOutgoing(Node n) {
        for (Edge e : n.outgoing) {
            Node out = e.target;
            if (out.flag) continue;
            BreakCycles.setInDegree(out, BreakCycles.getInDegree(out) - 1);
            BreakCycles.setDegree(out, BreakCycles.getOutDegree(out) - BreakCycles.getInDegree(out));
        }
    }

    @Override
    public void revisit(DirectedGraph g) {
        g.edges.stream().filter(Edge::isFeedback).forEach(Edge::invert);
    }

    @Override
    public void visit(DirectedGraph g) {
        this.graphNodes.resetFlags();
        for (Node n : g.nodes) {
            BreakCycles.setIncomingCount(n, n.incoming.size());
            this.graphNodes.add(n);
        }
        if (this.containsCycles(g)) {
            this.breakCycles(g);
        }
    }
}

