/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.config;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTriggerBase;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartSelector;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;

public class PostgreTriggerEditPage
extends EntityEditPage {
    private final PostgreTriggerBase trigger;
    private CSmartSelector<PostgreProcedure> functionCombo;
    PostgreProcedure selectedFunction;

    PostgreTriggerEditPage(PostgreTriggerBase trigger) {
        super((DBPDataSource)trigger.getDataSource(), DBSEntityType.TRIGGER);
        this.trigger = trigger;
    }

    public DBSObject getObject() {
        return this.trigger;
    }

    protected Control createPageContents(Composite parent) {
        Composite pageContents = (Composite)super.createPageContents(parent);
        this.addExtraCombo(pageContents);
        UIUtils.createControlLabel((Composite)pageContents, (String)PostgreMessages.dialog_trigger_edit_page_label_trigger_function);
        this.functionCombo = new PostgreProcedureSelector(pageContents, parent);
        GridData gd = new GridData(768);
        gd.widthHint = UIUtils.getFontHeight(this.functionCombo) * 30;
        this.functionCombo.setLayoutData((Object)gd);
        UIUtils.asyncExec(() -> this.functionCombo.layout());
        return pageContents;
    }

    public void addExtraCombo(Composite parent) {
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.selectedFunction != null;
    }

    private class PostgreProcedureSelector
    extends CSmartSelector<PostgreProcedure> {
        private final Composite parent;

        PostgreProcedureSelector(Composite pageContents, Composite parent) {
            super(pageContents, 2060, (ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_PROCEDURE);
                }

                public String getText(Object element) {
                    if (element == null) {
                        return "N/A";
                    }
                    return ((PostgreProcedure)element).getFullQualifiedSignature();
                }
            });
            this.parent = parent;
        }

        protected void dropDown(boolean drop) {
            DBNModel navigatorModel;
            DBNDatabaseNode dsNode;
            if (drop && (dsNode = (navigatorModel = DBWorkbench.getPlatform().getNavigatorModel()).getNodeByObject((DBSObject)PostgreTriggerEditPage.this.trigger.getDatabase())) != null) {
                DBNDatabaseNode curNode = PostgreTriggerEditPage.this.selectedFunction == null ? null : navigatorModel.getNodeByObject((DBSObject)PostgreTriggerEditPage.this.selectedFunction);
                DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)this.parent.getShell(), PostgreMessages.dialog_trigger_edit_page_select_function_title, (DBNNode)dsNode, (DBNNode)curNode, new Class[]{DBSInstance.class, DBSObjectContainer.class, PostgreProcedure.class}, new Class[]{PostgreProcedure.class}, null);
                if (node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getObject() instanceof PostgreProcedure) {
                    PostgreTriggerEditPage.this.functionCombo.removeAll();
                    PostgreTriggerEditPage.this.selectedFunction = (PostgreProcedure)((DBNDatabaseNode)node).getObject();
                    PostgreTriggerEditPage.this.functionCombo.addItem((Object)PostgreTriggerEditPage.this.selectedFunction);
                    PostgreTriggerEditPage.this.functionCombo.select((Object)PostgreTriggerEditPage.this.selectedFunction);
                    PostgreTriggerEditPage.this.updatePageState();
                }
            }
        }
    }
}

