/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.FreezeDetector;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetStateManager;

public final class BuildProgress {
    private static final Logger LOG = Logger.getInstance(BuildProgress.class);
    private final BuildDataManager dataManager;
    private final BuildTargetIndex targetIndex;
    private final Object2LongMap<BuildTargetType<?>> expectedBuildTimeForTarget = new Object2LongOpenHashMap();
    private final long expectedTotalTime;
    private final Map<BuildTarget<?>, Double> currentProgress = new HashMap();
    private long expectedTimeForFinishedTargets;
    private long absoluteBuildTime;
    private final Object2IntOpenHashMap<BuildTargetType<?>> totalTargets = new Object2IntOpenHashMap();
    private final Object2LongOpenHashMap<BuildTargetType<?>> totalBuildTimeForFullyRebuiltTargets = new Object2LongOpenHashMap();
    private final Object2IntOpenHashMap<BuildTargetType<?>> numberOfFullyRebuiltTargets = new Object2IntOpenHashMap();
    private final FreezeDetector freezeDetector;

    public BuildProgress(BuildDataManager dataManager, BuildTargetIndex targetIndex, List<BuildTargetChunk> allChunks, Predicate<? super BuildTargetChunk> isAffected) {
        this.dataManager = dataManager;
        this.targetIndex = targetIndex;
        LinkedHashSet targetTypes = new LinkedHashSet();
        Object2IntOpenHashMap totalAffectedTargets = new Object2IntOpenHashMap();
        for (BuildTargetChunk chunk : allChunks) {
            boolean affected = isAffected.test(chunk);
            for (BuildTarget<?> target : chunk.getTargets()) {
                if (this.targetIndex.isDummy(target)) continue;
                if (affected) {
                    totalAffectedTargets.addTo(target.getTargetType(), 1);
                    targetTypes.add(target.getTargetType());
                }
                this.totalTargets.addTo(target.getTargetType(), 1);
            }
        }
        long expectedTotalTime = 0L;
        for (BuildTargetType buildTargetType : targetTypes) {
            this.expectedBuildTimeForTarget.put((Object)buildTargetType, dataManager.getTargetStateManager().getAverageBuildTime(buildTargetType));
        }
        for (BuildTargetType buildTargetType : targetTypes) {
            if (this.expectedBuildTimeForTarget.getLong((Object)buildTargetType) != -1L) continue;
            this.expectedBuildTimeForTarget.put((Object)buildTargetType, BuildProgress.computeExpectedTimeBasedOnOtherTargets(buildTargetType, targetTypes, this.expectedBuildTimeForTarget));
        }
        for (BuildTargetType buildTargetType : targetTypes) {
            expectedTotalTime += this.expectedBuildTimeForTarget.getLong((Object)buildTargetType) * (long)totalAffectedTargets.getInt((Object)buildTargetType);
        }
        this.expectedTotalTime = Math.max(expectedTotalTime, 1L);
        this.freezeDetector = new FreezeDetector();
        this.freezeDetector.start();
        if (LOG.isDebugEnabled()) {
            LOG.debug("expected total time is " + this.expectedTotalTime);
            for (BuildTargetType buildTargetType : targetTypes) {
                LOG.debug(" expected build time for " + buildTargetType.getTypeId() + " is " + this.expectedBuildTimeForTarget.getLong((Object)buildTargetType));
            }
        }
    }

    private static long computeExpectedTimeBasedOnOtherTargets(BuildTargetType<?> type, Set<? extends BuildTargetType<?>> allTypes, Object2LongMap<BuildTargetType<?>> expectedBuildTimeForTarget) {
        BuilderRegistry registry = BuilderRegistry.getInstance();
        int baseTargetsCount = 0;
        long expectedTimeSum = 0L;
        for (BuildTargetType<?> anotherType : allTypes) {
            long realExpectedTime = expectedBuildTimeForTarget.getLong(anotherType);
            long defaultExpectedTime = registry.getExpectedBuildTimeForTarget(anotherType);
            if (realExpectedTime == -1L || defaultExpectedTime <= 0L) continue;
            ++baseTargetsCount;
            expectedTimeSum += realExpectedTime * registry.getExpectedBuildTimeForTarget(type) / defaultExpectedTime;
        }
        return baseTargetsCount == 0 ? registry.getExpectedBuildTimeForTarget(type) : expectedTimeSum / (long)baseTargetsCount;
    }

    private synchronized void notifyAboutTotalProgress(CompileContext context) {
        double expectedTimeForFinishedWork = this.expectedTimeForFinishedTargets;
        for (Map.Entry<BuildTarget<?>, Double> entry : this.currentProgress.entrySet()) {
            expectedTimeForFinishedWork += (double)this.expectedBuildTimeForTarget.getLong(entry.getKey().getTargetType()) * entry.getValue();
        }
        context.setDone((float)(expectedTimeForFinishedWork / (double)this.expectedTotalTime));
    }

    public synchronized void updateProgress(BuildTarget<?> target, double done, CompileContext context) {
        this.currentProgress.put(target, done);
        this.notifyAboutTotalProgress(context);
    }

    @ApiStatus.Internal
    public synchronized void onTargetChunkFinished(@NotNull Collection<? extends BuildTarget<?>> targets, CompileContext context) {
        if (targets == null) {
            BuildProgress.$$$reportNull$$$0(0);
        }
        boolean successful = !Utils.errorsDetected(context) && !context.getCancelStatus().isCanceled();
        long nonDummyTargetsCount = targets.stream().filter(it -> !this.targetIndex.isDummy((BuildTarget<?>)it)).count();
        for (BuildTarget<?> target : targets) {
            this.currentProgress.remove(target);
            if (this.targetIndex.isDummy(target)) continue;
            BuildTargetType<BuildTarget<?>> targetType = target.getTargetType();
            this.expectedTimeForFinishedTargets += this.expectedBuildTimeForTarget.getLong(targetType);
            long elapsedTime = this.freezeDetector.getAdjustedDuration(context.getCompilationStartStamp(target), System.currentTimeMillis());
            this.absoluteBuildTime += elapsedTime;
            if (!successful || !FSOperations.isMarkedDirty(context, target)) continue;
            long buildTime = elapsedTime / nonDummyTargetsCount;
            this.totalBuildTimeForFullyRebuiltTargets.addTo(targetType, buildTime);
            this.numberOfFullyRebuiltTargets.addTo(targetType, 1);
        }
        this.notifyAboutTotalProgress(context);
    }

    public void updateExpectedAverageTime() {
        this.freezeDetector.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("update expected build time for " + this.totalBuildTimeForFullyRebuiltTargets.size() + " target types");
        }
        if (this.totalBuildTimeForFullyRebuiltTargets.isEmpty()) {
            return;
        }
        ObjectIterator iterator = this.totalBuildTimeForFullyRebuiltTargets.object2LongEntrySet().fastIterator();
        BuildTargetStateManager targetStateManager = this.dataManager.getTargetStateManager();
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            BuildTargetType type = (BuildTargetType)entry.getKey();
            long totalTime = entry.getLongValue();
            long oldAverageTime = targetStateManager.getAverageBuildTime(type);
            long newAverageTime = oldAverageTime == -1L ? totalTime / (long)this.numberOfFullyRebuiltTargets.getInt((Object)type) : (totalTime + (long)(this.totalTargets.getInt((Object)type) - this.numberOfFullyRebuiltTargets.getInt((Object)type)) * oldAverageTime) / (long)this.totalTargets.getInt((Object)type);
            if (LOG.isDebugEnabled()) {
                LOG.debug(" " + type.getTypeId() + ": old=" + oldAverageTime + ", new=" + newAverageTime + " (based on " + this.numberOfFullyRebuiltTargets.getInt((Object)type) + " of " + this.totalTargets.getInt((Object)type) + " targets)");
            }
            targetStateManager.setAverageBuildTime(type, newAverageTime);
        }
    }

    public synchronized long getAbsoluteBuildTime() {
        return this.absoluteBuildTime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "org/jetbrains/jps/incremental/messages/BuildProgress", "onTargetChunkFinished"));
    }
}

