/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IssueLinkConfigurationDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JTextField myIssueIDTextField;
    private JTextField myIssueLinkTextField;
    private JLabel myErrorLabel;
    private JTextField myExampleIssueIDTextField;
    private JTextField myExampleIssueLinkTextField;

    protected IssueLinkConfigurationDialog(Project project) {
        super(project, false);
        this.$$$setupUI$$$();
        this.init();
        DocumentAdapter documentChangeListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                IssueLinkConfigurationDialog.this.updateFeedback();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/configurable/IssueLinkConfigurationDialog$1", "textChanged"));
            }
        };
        this.myIssueIDTextField.getDocument().addDocumentListener((DocumentListener)documentChangeListener);
        this.myIssueLinkTextField.getDocument().addDocumentListener((DocumentListener)documentChangeListener);
        this.myExampleIssueIDTextField.getDocument().addDocumentListener((DocumentListener)documentChangeListener);
        this.myIssueIDTextField.setText("Task_([A-Za-z]+)_(\\d+)");
        this.myIssueLinkTextField.setText("https://example.com/issue/$1/$2");
        this.myExampleIssueIDTextField.setText("Task_DA_113");
    }

    private void updateFeedback() {
        this.myErrorLabel.setText(" ");
        try {
            if (!this.myIssueIDTextField.getText().isEmpty()) {
                ArrayList matches = new ArrayList();
                IssueNavigationConfiguration.findIssueLinkMatches((CharSequence)this.myExampleIssueIDTextField.getText(), (IssueNavigationLink)this.getLink(), matches);
                IssueNavigationConfiguration.LinkMatch firstMatch = (IssueNavigationConfiguration.LinkMatch)ContainerUtil.getFirstItem(matches);
                if (firstMatch != null) {
                    this.myExampleIssueLinkTextField.setText(firstMatch.getTargetUrl());
                } else {
                    this.myExampleIssueLinkTextField.setText(VcsBundle.message((String)"add.issue.dialog.issue.no.match", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception ex) {
            this.myErrorLabel.setText(VcsBundle.message((String)"add.issue.dialog.invalid.regular.expression", (Object[])new Object[]{ex.getMessage()}));
            this.myExampleIssueLinkTextField.setText("");
        }
        this.setOKActionEnabled(this.myErrorLabel.getText().equals(" "));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getHelpId() {
        return "reference.settings.vcs.issue.navigation.add.link";
    }

    public IssueNavigationLink getLink() {
        return new IssueNavigationLink(this.myIssueIDTextField.getText(), this.myIssueLinkTextField.getText());
    }

    public void setLink(IssueNavigationLink link2) {
        this.myIssueIDTextField.setText(link2.getIssueRegexp());
        this.myIssueLinkTextField.setText(link2.getLinkRegexp());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myIssueIDTextField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(Color.red);
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/VcsBundle", IssueLinkConfigurationDialog.class).getString("add.issue.dialog.issue.example.border.title"), (int)0, (int)0, (Font)this.$$$getFont$$$(null, -1, -1, jPanel2.getFont()), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/VcsBundle", IssueLinkConfigurationDialog.class).getString("add.issue.dialog.issue.id.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/VcsBundle", IssueLinkConfigurationDialog.class).getString("add.issue.dialog.issue.link.label"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExampleIssueIDTextField = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myExampleIssueLinkTextField = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel2.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/VcsBundle", IssueLinkConfigurationDialog.class).getString("add.issue.dialog.issue.id.regular.expression"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/VcsBundle", IssueLinkConfigurationDialog.class).getString("add.issue.dialog.issue.link.replacement.expression"));
        jPanel3.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIssueIDTextField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        this.myIssueLinkTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        jLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

