/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslExpressionList
extends GradlePropertiesDslElement
implements GradleDslExpression {
    private static final Logger LOG = Logger.getInstance(GradleDslExpressionList.class);
    private final boolean myAppendToArgumentListWithOneElement;
    private boolean myShouldBeDeleted;
    private boolean myIsLiteralList;

    public GradleDslExpressionList(@Nullable GradleDslElement parent, @NotNull GradleNameElement name2, boolean isLiteralList) {
        if (name2 == null) {
            GradleDslExpressionList.$$$reportNull$$$0(0);
        }
        super(parent, null, name2);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, boolean isLiteralList, @NotNull GradleNameElement name2) {
        if (parent == null) {
            GradleDslExpressionList.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            GradleDslExpressionList.$$$reportNull$$$0(3);
        }
        super(parent, psiElement, name2);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull GradleNameElement name2, boolean appendToArgumentListWithOneElement) {
        if (parent == null) {
            GradleDslExpressionList.$$$reportNull$$$0(4);
        }
        if (psiElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(5);
        }
        if (name2 == null) {
            GradleDslExpressionList.$$$reportNull$$$0(6);
        }
        super(parent, psiElement, name2);
        this.myAppendToArgumentListWithOneElement = appendToArgumentListWithOneElement;
        this.myIsLiteralList = false;
    }

    public GradleDslExpressionList(@Nullable GradleDslElement parent, @NotNull GradleNameElement name2) {
        if (name2 == null) {
            GradleDslExpressionList.$$$reportNull$$$0(7);
        }
        super(parent, null, name2);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = false;
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        if (expression == null) {
            GradleDslExpressionList.$$$reportNull$$$0(8);
        }
        super.addParsedElement(expression);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression) {
        if (expression == null) {
            GradleDslExpressionList.$$$reportNull$$$0(9);
        }
        this.setNewElement(expression);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression, int index) {
        if (expression == null) {
            GradleDslExpressionList.$$$reportNull$$$0(10);
        }
        this.addNewElementAt(index, expression);
    }

    public void removeElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslExpressionList.$$$reportNull$$$0(11);
        }
        super.removeProperty(element);
    }

    public GradleDslExpression getElementAt(int index) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index < 0 || index > expressions.size()) {
            return null;
        }
        return expressions.get(index);
    }

    public int findIndexOf(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslExpressionList.$$$reportNull$$$0(12);
        }
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        for (int i = 0; i < expressions.size(); ++i) {
            if (!expressions.get(i).equals(element)) continue;
            return i;
        }
        return -1;
    }

    public void replaceExpression(@NotNull GradleDslExpression oldExpression, @NotNull GradleDslExpression newExpression) {
        if (oldExpression == null) {
            GradleDslExpressionList.$$$reportNull$$$0(13);
        }
        if (newExpression == null) {
            GradleDslExpressionList.$$$reportNull$$$0(14);
        }
        super.replaceElement(oldExpression, newExpression);
    }

    @NotNull
    public List<GradleDslExpression> getExpressions() {
        List<GradleDslExpression> list = this.getPropertyElements(GradleDslExpression.class);
        if (list == null) {
            GradleDslExpressionList.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public List<GradleDslSimpleExpression> getSimpleExpressions() {
        List<GradleDslSimpleExpression> list = this.getExpressions().stream().filter(e -> e instanceof GradleDslSimpleExpression).map(e -> (GradleDslSimpleExpression)e).collect(Collectors.toList());
        if (list == null) {
            GradleDslExpressionList.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public <T> List<T> getLiterals(@NotNull Class<T> clazz) {
        if (clazz == null) {
            GradleDslExpressionList.$$$reportNull$$$0(17);
        }
        List list = this.getSimpleExpressions().stream().map(e -> e.getValue(clazz)).filter(e -> e != null).collect(Collectors.toList());
        if (list == null) {
            GradleDslExpressionList.$$$reportNull$$$0(18);
        }
        return list;
    }

    public boolean isLiteralList() {
        return this.myIsLiteralList;
    }

    public boolean isAppendToArgumentListWithOneElement() {
        return this.myAppendToArgumentListWithOneElement;
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslExpressionList(this);
    }

    @Override
    public void delete() {
        this.myShouldBeDeleted = true;
        super.delete();
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslExpressionList(this);
        ModelEffectDescription effect = this.getModelEffect();
        if (effect != null && effect.semantics == ModelSemanticsDescription.CREATE_WITH_VALUE && this.isStructurallyModified()) {
            this.deleteAndRecreate();
        } else {
            super.apply();
        }
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.getPsiElement();
    }

    public boolean shouldBeDeleted() {
        return !this.isLiteralList() || this.myShouldBeDeleted;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        List list = ContainerUtil.filter(this.getDependencies(), e -> e.isResolved());
        if (list == null) {
            GradleDslExpressionList.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Override
    public void setParsedElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslExpressionList.$$$reportNull$$$0(20);
        }
        if (!(element instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(element)));
            return;
        }
        super.setParsedElement(element);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslExpressionList.$$$reportNull$$$0(21);
        }
        if (!(element instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(element)));
            return;
        }
        super.addParsedElement(element);
    }

    @Override
    public void addToParsedExpressionList(@NotNull String property, @NotNull GradleDslElement element) {
        if (property == null) {
            GradleDslExpressionList.$$$reportNull$$$0(22);
        }
        if (element == null) {
            GradleDslExpressionList.$$$reportNull$$$0(23);
        }
        if (!(element instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(element)));
            return;
        }
        super.addToParsedExpressionList(property, element);
    }

    @Override
    public void setNewElement(@NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(24);
        }
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(newElement)));
            return;
        }
        super.setNewElement(newElement);
    }

    @Override
    public void addNewElementAt(int index, @NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(25);
        }
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(newElement)));
            return;
        }
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index > expressions.size()) {
            LOG.warn((Throwable)new IndexOutOfBoundsException(index + " is out of bounds for size " + expressions.size()));
            return;
        }
        super.addNewElementAt(index, newElement);
    }

    @Override
    public void replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(26);
        }
        if (newElement == null) {
            GradleDslExpressionList.$$$reportNull$$$0(27);
        }
        if (!(oldElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression (old): " + String.valueOf(oldElement)));
            return;
        }
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression (new): " + String.valueOf(newElement)));
            return;
        }
        super.replaceElement(oldElement, newElement);
    }

    @Override
    @NotNull
    public GradleDslExpressionList copy() {
        GradleDslExpressionList listClone = new GradleDslExpressionList(this.myParent, GradleNameElement.copy(this.myName), false);
        for (GradleDslElement element : this.getCurrentElements()) {
            GradleDslExpression sourceExpression = (GradleDslExpression)element;
            GradleDslExpression copiedExpression = sourceExpression.copy();
            listClone.setNewElement(copiedExpression);
        }
        GradleDslExpressionList gradleDslExpressionList = listClone;
        if (gradleDslExpressionList == null) {
            GradleDslExpressionList.$$$reportNull$$$0(28);
        }
        return gradleDslExpressionList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 18, 19, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpressionList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpressionList";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleExpressions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiterals";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addParsedExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addNewExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIndexOf";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 28: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLiterals";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setParsedElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addParsedElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addToParsedExpressionList";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setNewElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addNewElementAt";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 18, 19, 28 -> new IllegalStateException(string);
        };
    }
}

