/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldHaveRootCauseExactlyInstance
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveRootCauseExactlyInstance(Throwable actual, Class<? extends Throwable> expectedCauseType) {
        return Throwables.getRootCause(actual) == null ? new ShouldHaveRootCauseExactlyInstance(expectedCauseType, actual) : new ShouldHaveRootCauseExactlyInstance(actual, expectedCauseType);
    }

    private ShouldHaveRootCauseExactlyInstance(Throwable actual, Class<? extends Throwable> expectedCauseType) {
        super("%nExpecting a throwable with root cause being exactly an instance of:%n  %s%nbut was an instance of:%n  %s%n%nThrowable that failed the check:%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseType, Throwables.getRootCause(actual).getClass());
    }

    private ShouldHaveRootCauseExactlyInstance(Class<? extends Throwable> expectedCauseType, Throwable actual) {
        super("%nExpecting a throwable with root cause being exactly an instance of:%n  %s%nbut current throwable has no cause.%nThrowable that failed the check:%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseType);
    }
}

