/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GpgSigner {
    private static final Logger LOG = LoggerFactory.getLogger(GpgSigner.class);

    public static GpgSigner getDefault() {
        return DefaultSigner.getDefault();
    }

    public static void setDefault(GpgSigner signer) {
        DefaultSigner.setDefault(signer);
    }

    public abstract void sign(@NonNull CommitBuilder var1, @Nullable String var2, @NonNull PersonIdent var3, CredentialsProvider var4) throws CanceledException;

    public abstract boolean canLocateSigningKey(@Nullable String var1, @NonNull PersonIdent var2, CredentialsProvider var3) throws CanceledException;

    private static class DefaultSigner {
        private static volatile GpgSigner defaultSigner = DefaultSigner.loadGpgSigner();

        private static GpgSigner loadGpgSigner() {
            try {
                ServiceLoader<GpgSigner> loader = ServiceLoader.load(GpgSigner.class);
                Iterator<GpgSigner> iter = loader.iterator();
                if (iter.hasNext()) {
                    return iter.next();
                }
            }
            catch (ServiceConfigurationError e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }

        private DefaultSigner() {
        }

        public static GpgSigner getDefault() {
            return defaultSigner;
        }

        public static void setDefault(GpgSigner signer) {
            defaultSigner = signer;
        }
    }
}

