/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.k2;

import androidx.compose.compiler.plugins.kotlin.k2.ComposableCallCheckerKt;
import androidx.compose.compiler.plugins.kotlin.k2.FirUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/compiler/plugins/kotlin/k2/ComposableFunctionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "kotlin-compose-compiler-plugin"})
public final class ComposableFunctionCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final ComposableFunctionCallChecker INSTANCE = new ComposableFunctionCallChecker();

    private ComposableFunctionCallChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull FirFunctionCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default((FirReference)((FirReference)expression.getCalleeReference()), (boolean)false, (int)1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol calleeFunction = firCallableSymbol;
        if (Intrinsics.areEqual((Object)calleeFunction.getOrigin(), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) {
            return;
        }
        if (FirUtilsKt.isComposable(calleeFunction, context.getSession())) {
            ComposableCallCheckerKt.access$checkComposableCall((FirQualifiedAccessExpression)expression, calleeFunction, context, reporter);
        } else if (CallableIdUtilsKt.isInvoke((CallableId)calleeFunction.getCallableId())) {
            ComposableCallCheckerKt.access$checkInvoke((FirQualifiedAccessExpression)expression, context, reporter);
        }
    }
}

