/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.scanning;

import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Application;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.BlockingDefault;
import org.jboss.resteasy.reactive.common.processor.JandexUtil;
import org.jboss.resteasy.reactive.common.processor.NameBindingUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ScannedSerializer;
import org.jboss.resteasy.reactive.common.processor.scanning.SerializerScanningResult;

public class ResteasyReactiveScanner {
    public static final Map<DotName, String> BUILTIN_HTTP_ANNOTATIONS_TO_METHOD = Map.of(ResteasyReactiveDotNames.GET, "GET", ResteasyReactiveDotNames.POST, "POST", ResteasyReactiveDotNames.HEAD, "HEAD", ResteasyReactiveDotNames.PUT, "PUT", ResteasyReactiveDotNames.DELETE, "DELETE", ResteasyReactiveDotNames.PATCH, "PATCH", ResteasyReactiveDotNames.OPTIONS, "OPTIONS");
    public static final Map<String, DotName> METHOD_TO_BUILTIN_HTTP_ANNOTATIONS = Map.of("GET", ResteasyReactiveDotNames.GET, "POST", ResteasyReactiveDotNames.POST, "HEAD", ResteasyReactiveDotNames.HEAD, "PUT", ResteasyReactiveDotNames.PUT, "DELETE", ResteasyReactiveDotNames.DELETE, "PATCH", ResteasyReactiveDotNames.PATCH, "OPTIONS", ResteasyReactiveDotNames.OPTIONS);
    public static final Set<DotName> ANNOTATIONS_REQUIRING_FIELD_INJECTION = new HashSet<DotName>(Arrays.asList(ResteasyReactiveDotNames.PATH_PARAM, ResteasyReactiveDotNames.QUERY_PARAM, ResteasyReactiveDotNames.HEADER_PARAM, ResteasyReactiveDotNames.FORM_PARAM, ResteasyReactiveDotNames.MATRIX_PARAM, ResteasyReactiveDotNames.COOKIE_PARAM, ResteasyReactiveDotNames.REST_PATH_PARAM, ResteasyReactiveDotNames.REST_QUERY_PARAM, ResteasyReactiveDotNames.REST_HEADER_PARAM, ResteasyReactiveDotNames.REST_FORM_PARAM, ResteasyReactiveDotNames.REST_MATRIX_PARAM, ResteasyReactiveDotNames.REST_COOKIE_PARAM, ResteasyReactiveDotNames.BEAN_PARAM));

    public static ApplicationScanningResult scanForApplicationClass(IndexView index, Set<String> excludedClasses) {
        Collection applications = index.getAllKnownSubclasses(ResteasyReactiveDotNames.APPLICATION);
        HashSet<String> allowedClasses = new HashSet<String>();
        HashSet<String> singletonClasses = new HashSet<String>();
        HashSet<String> globalNameBindings = new HashSet();
        boolean filterClasses = !excludedClasses.isEmpty();
        Application application = null;
        ClassInfo selectedAppClass = null;
        BlockingDefault blocking = BlockingDefault.AUTOMATIC;
        for (ClassInfo applicationClassInfo : applications) {
            if (Modifier.isAbstract(applicationClassInfo.flags()) || excludedClasses.contains(applicationClassInfo.name().toString())) continue;
            if (selectedAppClass != null) {
                throw new RuntimeException("More than one Application class: " + String.valueOf(applications));
            }
            selectedAppClass = applicationClassInfo;
            if (ResteasyReactiveScanner.appClassHasInject(selectedAppClass)) {
                throw new RuntimeException("'@Inject' cannot be used with a '" + String.valueOf(ResteasyReactiveDotNames.APPLICATION) + "' class. Offending class is: '" + String.valueOf(selectedAppClass.name()) + "'");
            }
            String applicationClass = applicationClassInfo.name().toString();
            try {
                Class<?> appClass = Thread.currentThread().getContextClassLoader().loadClass(applicationClass);
                application = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Set classes = application.getClasses();
                if (!classes.isEmpty()) {
                    for (Class klass : classes) {
                        allowedClasses.add(klass.getName());
                    }
                    filterClasses = true;
                }
                if (!(classes = application.getSingletons().stream().map(Object::getClass).collect(Collectors.toSet())).isEmpty()) {
                    for (Class klass : classes) {
                        allowedClasses.add(klass.getName());
                        singletonClasses.add(klass.getName());
                    }
                    filterClasses = true;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to handle class: " + applicationClass, e);
            }
            int numAnnotations = 0;
            if (applicationClassInfo.hasDeclaredAnnotation(ResteasyReactiveDotNames.BLOCKING)) {
                blocking = BlockingDefault.BLOCKING;
                ++numAnnotations;
            }
            if (applicationClassInfo.hasDeclaredAnnotation(ResteasyReactiveDotNames.NON_BLOCKING)) {
                blocking = BlockingDefault.NON_BLOCKING;
                ++numAnnotations;
            }
            if (applicationClassInfo.hasDeclaredAnnotation(ResteasyReactiveDotNames.RUN_ON_VIRTUAL_THREAD)) {
                blocking = BlockingDefault.RUN_ON_VIRTUAL_THREAD;
                ++numAnnotations;
            }
            if (numAnnotations <= 1) continue;
            throw new DeploymentException("JAX-RS Application class '" + String.valueOf(applicationClassInfo.name()) + "' contains multiple conflicting @Blocking, @NonBlocking and @RunOnVirtualThread annotations.");
        }
        if (selectedAppClass != null) {
            globalNameBindings = NameBindingUtil.nameBindingNames(index, selectedAppClass);
        }
        return new ApplicationScanningResult(allowedClasses, singletonClasses, excludedClasses, globalNameBindings, filterClasses, application, selectedAppClass, blocking);
    }

    public static SerializerScanningResult scanForSerializers(IndexView index, ApplicationScanningResult applicationScanningResult) {
        Collection readers = index.getAllKnownImplementors(ResteasyReactiveDotNames.MESSAGE_BODY_READER);
        ArrayList<ScannedSerializer> readerList = new ArrayList<ScannedSerializer>();
        for (ClassInfo readerClass : readers) {
            AnnotationInstance constrainedToInstance;
            ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationScanningResult.keepProvider(readerClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            List<Type> typeParameters = JandexUtil.resolveTypeParameters(readerClass.name(), ResteasyReactiveDotNames.MESSAGE_BODY_READER, index);
            RuntimeType runtimeType = null;
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.SERVER_ONLY) {
                runtimeType = RuntimeType.SERVER;
            }
            List<String> mediaTypeStrings = Collections.emptyList();
            AnnotationInstance consumesAnnotation = readerClass.declaredAnnotation(ResteasyReactiveDotNames.CONSUMES);
            if (consumesAnnotation != null) {
                mediaTypeStrings = Arrays.asList(consumesAnnotation.value().asStringArray());
            }
            if ((constrainedToInstance = readerClass.declaredAnnotation(ResteasyReactiveDotNames.CONSTRAINED_TO)) != null) {
                runtimeType = RuntimeType.valueOf((String)constrainedToInstance.value().asEnum());
            }
            int priority = 5000;
            AnnotationInstance priorityInstance = readerClass.declaredAnnotation(ResteasyReactiveDotNames.PRIORITY);
            if (priorityInstance != null) {
                priority = priorityInstance.value().asInt();
            }
            readerList.add(new ScannedSerializer(readerClass, typeParameters.get(0).name().toString(), mediaTypeStrings, runtimeType, false, priority));
        }
        ArrayList<ScannedSerializer> writerList = new ArrayList<ScannedSerializer>();
        Collection writers = index.getAllKnownImplementors(ResteasyReactiveDotNames.MESSAGE_BODY_WRITER);
        for (ClassInfo writerClass : writers) {
            ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationScanningResult.keepProvider(writerClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            RuntimeType runtimeType = null;
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.SERVER_ONLY) {
                runtimeType = RuntimeType.SERVER;
            }
            List<String> mediaTypeStrings = Collections.emptyList();
            AnnotationInstance producesAnnotation = writerClass.declaredAnnotation(ResteasyReactiveDotNames.PRODUCES);
            if (producesAnnotation != null) {
                mediaTypeStrings = Arrays.asList(producesAnnotation.value().asStringArray());
            }
            List<Type> typeParameters = JandexUtil.resolveTypeParameters(writerClass.name(), ResteasyReactiveDotNames.MESSAGE_BODY_WRITER, index);
            AnnotationInstance constrainedToInstance = writerClass.declaredAnnotation(ResteasyReactiveDotNames.CONSTRAINED_TO);
            if (constrainedToInstance != null) {
                runtimeType = RuntimeType.valueOf((String)constrainedToInstance.value().asEnum());
            }
            int priority = 5000;
            AnnotationInstance priorityInstance = writerClass.declaredAnnotation(ResteasyReactiveDotNames.PRIORITY);
            if (priorityInstance != null) {
                priority = priorityInstance.value().asInt();
            }
            writerList.add(new ScannedSerializer(writerClass, typeParameters.get(0).name().toString(), mediaTypeStrings, runtimeType, false, priority));
        }
        return new SerializerScanningResult(readerList, writerList);
    }

    private static boolean appClassHasInject(ClassInfo appClass) {
        if (appClass.annotationsMap() == null) {
            return false;
        }
        List injectInstances = (List)appClass.annotationsMap().get(ResteasyReactiveDotNames.CDI_INJECT);
        return injectInstances != null && !injectInstances.isEmpty();
    }

    public static ResourceScanningResult scanResources(IndexView index, Map<DotName, ClassInfo> additionalResources, Map<DotName, String> additionalResourcePaths) {
        Collection paths = index.getAnnotations(ResteasyReactiveDotNames.PATH);
        ArrayList allPaths = new ArrayList(paths);
        HashMap<DotName, ClassInfo> scannedResources = new HashMap<DotName, ClassInfo>(additionalResources);
        HashMap<DotName, String> scannedResourcePaths = new HashMap<DotName, String>(additionalResourcePaths);
        HashMap<DotName, String> pathInterfaces = new HashMap<DotName, String>();
        HashMap<DotName, MethodInfo> resourcesThatNeedCustomProducer = new HashMap<DotName, MethodInfo>();
        ArrayList<MethodInfo> methodExceptionMappers = new ArrayList<MethodInfo>();
        HashSet<DotName> requestScopedResources = new HashSet<DotName>();
        HashSet<DotName> interfacesWithPathOnMethods = new HashSet<DotName>();
        for (AnnotationInstance annotation : allPaths) {
            Object clazz;
            if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                List list;
                clazz = annotation.target().asClass();
                if (!Modifier.isInterface(clazz.flags())) {
                    scannedResources.put(clazz.name(), (ClassInfo)clazz);
                    scannedResourcePaths.put(clazz.name(), annotation.value().asString());
                } else {
                    pathInterfaces.put(clazz.name(), annotation.value().asString());
                }
                MethodInfo methodInfo = ResteasyReactiveScanner.hasJaxRsCtorParams((ClassInfo)clazz);
                if (methodInfo != null) {
                    resourcesThatNeedCustomProducer.put(clazz.name(), methodInfo);
                }
                if (ResteasyReactiveScanner.hasJaxRsFieldInjection((ClassInfo)clazz, index)) {
                    requestScopedResources.add(clazz.name());
                }
                if ((list = (List)clazz.annotationsMap().get(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER)) == null) continue;
                for (AnnotationInstance instance : list) {
                    if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                    methodExceptionMappers.add(instance.target().asMethod());
                }
                continue;
            }
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !Modifier.isInterface((clazz = annotation.target().asMethod().declaringClass()).flags())) continue;
            interfacesWithPathOnMethods.add(clazz.name());
        }
        List<ClassInfo> abstractClasses = scannedResources.values().stream().filter(ClassInfo::isAbstract).toList();
        abstractClasses.forEach(abstractScannedResource -> {
            Collection allSubclasses = index.getAllKnownSubclasses(abstractScannedResource.name());
            if (allSubclasses.size() != 1) {
                return;
            }
            ClassInfo subclass = (ClassInfo)allSubclasses.iterator().next();
            if (!scannedResources.containsKey(subclass.name())) {
                scannedResources.put(subclass.name(), subclass);
                scannedResources.remove(abstractScannedResource.name());
                scannedResourcePaths.put(subclass.name(), (String)scannedResourcePaths.get(abstractScannedResource.name()));
                scannedResourcePaths.remove(abstractScannedResource.name());
            }
        });
        HashMap<DotName, String> clientInterfaces = new HashMap<DotName, String>(pathInterfaces);
        for (DotName dotName : interfacesWithPathOnMethods) {
            if (clientInterfaces.containsKey(dotName)) continue;
            clientInterfaces.put(dotName, "");
        }
        HashMap<DotName, String> clientInterfaceSubtypes = new HashMap<DotName, String>();
        for (DotName dotName : clientInterfaces.keySet()) {
            ResteasyReactiveScanner.addClientSubInterfaces(dotName, index, clientInterfaceSubtypes, clientInterfaces);
        }
        clientInterfaces.putAll(clientInterfaceSubtypes);
        for (Map.Entry entry : pathInterfaces.entrySet()) {
            for (ClassInfo clazz : index.getAllKnownImplementors((DotName)entry.getKey())) {
                if (Modifier.isAbstract(clazz.flags()) || clazz.enclosingClass() != null && !Modifier.isStatic(clazz.flags()) || clazz.enclosingMethod() != null || scannedResources.containsKey(clazz.name())) continue;
                scannedResources.put(clazz.name(), clazz);
                scannedResourcePaths.put(clazz.name(), (String)entry.getValue());
                List exceptionMapperAnnotationInstances = (List)clazz.annotationsMap().get(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER);
                if (exceptionMapperAnnotationInstances == null) continue;
                for (AnnotationInstance instance : exceptionMapperAnnotationInstances) {
                    if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                    methodExceptionMappers.add(instance.target().asMethod());
                }
            }
        }
        HashMap<DotName, String> hashMap = new HashMap<DotName, String>(BUILTIN_HTTP_ANNOTATIONS_TO_METHOD);
        Collection collection = index.getAnnotations(ResteasyReactiveDotNames.HTTP_METHOD);
        for (Object httpMethodInstance : collection) {
            if (httpMethodInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            hashMap.put(httpMethodInstance.target().asClass().name(), httpMethodInstance.value().asString());
        }
        Set methodAnnotations = hashMap.keySet();
        for (Object methodAnnotation : methodAnnotations) {
            for (Object methodAnnotationInstance : index.getAnnotations((DotName)methodAnnotation)) {
                if (methodAnnotationInstance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo annotatedMethod = methodAnnotationInstance.target().asMethod();
                ClassInfo classWithJaxrsMethod = annotatedMethod.declaringClass();
                if (!Modifier.isAbstract(annotatedMethod.flags()) || !Modifier.isInterface(classWithJaxrsMethod.flags()) || clientInterfaces.containsKey(classWithJaxrsMethod.name())) continue;
                clientInterfaces.put(classWithJaxrsMethod.name(), "");
            }
        }
        ArrayDeque<ClassInfo> toScan = new ArrayDeque<ClassInfo>();
        for (DotName methodAnnotation : hashMap.keySet()) {
            for (AnnotationInstance instance : index.getAnnotations(methodAnnotation)) {
                MethodInfo method = instance.target().asMethod();
                ClassInfo classInfo = method.declaringClass();
                toScan.add(classInfo);
            }
        }
        for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveDotNames.PATH)) {
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo method = instance.target().asMethod();
            ClassInfo classInfo = method.declaringClass();
            toScan.add(classInfo);
        }
        HashMap<DotName, ClassInfo> possibleSubResources = new HashMap<DotName, ClassInfo>();
        while (!toScan.isEmpty()) {
            ClassInfo classInfo = (ClassInfo)toScan.poll();
            if (scannedResources.containsKey(classInfo.name()) || pathInterfaces.containsKey(classInfo.name()) || possibleSubResources.containsKey(classInfo.name())) continue;
            possibleSubResources.put(classInfo.name(), classInfo);
            toScan.addAll(index.getKnownDirectImplementors(classInfo.name()));
            toScan.addAll(index.getKnownDirectSubclasses(classInfo.name()));
        }
        return new ResourceScanningResult(index, scannedResources, scannedResourcePaths, possibleSubResources, pathInterfaces, clientInterfaces, resourcesThatNeedCustomProducer, hashMap, methodExceptionMappers, requestScopedResources);
    }

    private static void addClientSubInterfaces(DotName interfaceName, IndexView index, Map<DotName, String> clientInterfaceSubtypes, Map<DotName, String> clientInterfaces) {
        Collection subclasses = index.getKnownDirectImplementors(interfaceName);
        for (ClassInfo subclass : subclasses) {
            if (clientInterfaces.containsKey(subclass.name()) || !Modifier.isInterface(subclass.flags()) || clientInterfaceSubtypes.containsKey(subclass.name())) continue;
            clientInterfaceSubtypes.put(subclass.name(), clientInterfaces.get(interfaceName));
            ResteasyReactiveScanner.addClientSubInterfaces(subclass.name(), index, clientInterfaceSubtypes, clientInterfaces);
        }
    }

    private static MethodInfo hasJaxRsCtorParams(ClassInfo classInfo) {
        List methods = classInfo.methods();
        ArrayList<MethodInfo> ctors = new ArrayList<MethodInfo>();
        for (MethodInfo method : methods) {
            if (!method.name().equals("<init>")) continue;
            ctors.add(method);
        }
        if (ctors.size() != 1) {
            return null;
        }
        MethodInfo ctor = (MethodInfo)ctors.get(0);
        if (ctor.parametersCount() == 0) {
            return null;
        }
        boolean needsHandling = false;
        for (DotName dotName : ResteasyReactiveDotNames.RESOURCE_CTOR_PARAMS_THAT_NEED_HANDLING) {
            if (!ctor.hasAnnotation(dotName)) continue;
            needsHandling = true;
            break;
        }
        return needsHandling ? ctor : null;
    }

    private static boolean hasJaxRsFieldInjection(ClassInfo classInfo, IndexView index) {
        DotName parentDotName;
        do {
            for (FieldInfo field : classInfo.fields()) {
                List annotations = field.annotations();
                if (!annotations.stream().anyMatch(an -> ANNOTATIONS_REQUIRING_FIELD_INJECTION.contains(an.name()))) continue;
                return true;
            }
            parentDotName = classInfo.superName();
            if (!parentDotName.equals((Object)ResteasyReactiveDotNames.OBJECT)) continue;
            return false;
        } while ((classInfo = index.getClassByName(parentDotName)) != null);
        return false;
    }
}

