/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.protocol;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.protocols.JDBC_PING2;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.UUID;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;

public class KEYCLOAK_JDBC_PING2
extends JDBC_PING2 {
    private JpaConnectionProviderFactory factory;

    protected void handleView(View new_view, View old_view, boolean coord_changed) {
        this.learnExistingAddresses();
        if (this.is_coord) {
            if (this.remove_old_coords_on_view_change) {
                Address old_coord;
                Address address = old_coord = old_view != null ? old_view.getCreator() : null;
                if (old_coord != null) {
                    this.remove(this.cluster_name, old_coord);
                }
            }
            Address[] left = View.diff((View)old_view, (View)new_view)[1];
            if (coord_changed || this.update_store_on_view_change || left.length > 0) {
                this.writeAll(left);
                if (this.remove_all_data_on_view_change) {
                    this.removeAllNotInCurrentView();
                }
                if (this.remove_all_data_on_view_change || this.remove_old_coords_on_view_change) {
                    this.startInfoWriter();
                }
            }
        } else if (coord_changed && !this.remove_all_data_on_view_change) {
            PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
            PingData coord_data = new PingData(this.local_addr, true, NameCache.get((Address)this.local_addr), physical_addr).coord(this.is_coord);
            this.write(Collections.singletonList(coord_data), this.cluster_name);
        }
    }

    protected void removeAll(String clustername) {
        throw new RuntimeException("Not implemented as it is unsafe");
    }

    private void removeAllNotInCurrentView() {
        try {
            List list = this.readFromDB(this.getClusterName());
            for (PingData data : list) {
                Address addr = data.getAddress();
                if (this.view == null || this.view.containsMember(addr)) continue;
                this.addDiscoveryResponseToCaches(addr, data.getLogicalName(), data.getPhysicalAddr());
                this.remove(this.cluster_name, addr);
            }
        }
        catch (Exception e) {
            this.log.error(String.format("%s: failed reading from the DB", this.local_addr), (Throwable)e);
        }
    }

    protected void learnExistingAddresses() {
        try {
            List list = this.readFromDB(this.getClusterName());
            for (PingData data : list) {
                Address addr = data.getAddress();
                if (this.local_addr == null || this.local_addr.equals((Object)addr)) continue;
                this.addDiscoveryResponseToCaches(addr, data.getLogicalName(), data.getPhysicalAddr());
            }
        }
        catch (Exception e) {
            this.log.error(String.format("%s: failed reading from the DB", this.local_addr), (Throwable)e);
        }
    }

    public synchronized boolean isInfoWriterRunning() {
        return false;
    }

    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        if (initial_discovery) {
            try {
                List newPingData;
                List pingData = this.readFromDB(this.cluster_name);
                PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
                PingData coord_data = new PingData(this.local_addr, true, NameCache.get((Address)this.local_addr), physical_addr).coord(this.is_coord);
                this.write(Collections.singletonList(coord_data), this.cluster_name);
                while (pingData.stream().noneMatch(PingData::isCoord) && !(newPingData = this.readFromDB(this.cluster_name)).stream().map(PingData::getAddress).collect(Collectors.toSet()).equals(pingData.stream().map(PingData::getAddress).collect(Collectors.toSet())) && !pingData.stream().anyMatch(PingData::isCoord)) {
                    pingData = newPingData;
                }
            }
            catch (Exception e) {
                this.log.error(String.format("%s: failed reading from the DB", this.local_addr), (Throwable)e);
            }
        }
        super.findMembers(members, initial_discovery, responses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToDB(PingData data, String clustername) throws SQLException {
        block19: {
            this.lock.lock();
            try (Connection connection = this.getConnection();){
                if (this.call_insert_sp != null && this.insert_sp != null) {
                    this.callInsertStoredProcedure(connection, data, clustername);
                    break block19;
                }
                boolean isAutocommit = connection.getAutoCommit();
                try {
                    if (isAutocommit) {
                        connection.setAutoCommit(false);
                    }
                    this.delete(connection, clustername, data.getAddress());
                    this.insert(connection, data, clustername);
                    if (isAutocommit) {
                        connection.commit();
                    }
                }
                catch (SQLException e) {
                    if (isAutocommit) {
                        connection.rollback();
                    }
                    throw e;
                }
                finally {
                    if (isAutocommit) {
                        connection.setAutoCommit(true);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public <T extends Protocol> T addr(Address addr) {
        addr = KEYCLOAK_JDBC_PING2.toUUID(addr);
        return (T)super.addr(addr);
    }

    public <T extends Protocol> T setAddress(Address addr) {
        addr = KEYCLOAK_JDBC_PING2.toUUID(addr);
        return (T)super.setAddress(addr);
    }

    protected void delete(Connection conn, String clustername, Address addressToDelete) throws SQLException {
        super.delete(conn, clustername, KEYCLOAK_JDBC_PING2.toUUID(addressToDelete));
    }

    protected void delete(String clustername, Address addressToDelete) throws SQLException {
        super.delete(clustername, KEYCLOAK_JDBC_PING2.toUUID(addressToDelete));
    }

    protected void insert(Connection connection, PingData data, String clustername) throws SQLException {
        if (data.getAddress() instanceof ExtendedUUID) {
            data = new PingData(KEYCLOAK_JDBC_PING2.toUUID(data.getAddress()), data.isServer(), data.getLogicalName(), data.getPhysicalAddr()).coord(data.isCoord());
        }
        super.insert(connection, data, clustername);
    }

    private static Address toUUID(Address addr) {
        if (addr instanceof ExtendedUUID) {
            ExtendedUUID eUUID = (ExtendedUUID)addr;
            addr = new UUID(eUUID.getMostSignificantBits(), eUUID.getLeastSignificantBits());
        }
        return addr;
    }

    protected void loadDriver() {
    }

    protected Connection getConnection() {
        return this.factory.getConnection();
    }

    public void setJpaConnectionProviderFactory(JpaConnectionProviderFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }
}

