/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.keycloak.client.cli.common.AttributeKey;
import org.keycloak.client.cli.common.AttributeOperation;
import org.keycloak.client.cli.util.OutputUtil;

public class ReflectionUtil {
    public static void setAttributes(JsonNode client, List<AttributeOperation> attrs) {
        for (AttributeOperation item : attrs) {
            AttributeKey attr = item.getKey();
            JsonNode nested = client;
            List<AttributeKey.Component> cs = attr.getComponents();
            for (int i = 0; i < cs.size(); ++i) {
                AttributeKey.Component c = cs.get(i);
                if (i == cs.size() - 1) {
                    String val = item.getValue();
                    ObjectNode obj = (ObjectNode)nested;
                    if (AttributeOperation.Type.SET == item.getType()) {
                        JsonNode valNode = ReflectionUtil.valueToJsonNode(val);
                        if (c.isArray() || attr.isAppend()) {
                            JsonNode list = obj.get(c.getName());
                            if (!(list instanceof ArrayNode)) {
                                list = OutputUtil.MAPPER.createArrayNode();
                                obj.set(c.getName(), list);
                            }
                            ReflectionUtil.setArrayItem((ArrayNode)list, c.getIndex(), valNode);
                            continue;
                        }
                        ((ObjectNode)nested).set(c.getName(), valNode);
                        continue;
                    }
                    if (c.isArray()) {
                        JsonNode list = obj.get(c.getName());
                        if (!(list instanceof ArrayNode)) continue;
                        ReflectionUtil.removeArrayItem((ArrayNode)list, c.getIndex());
                        continue;
                    }
                    obj.remove(c.getName());
                    continue;
                }
                JsonNode node = nested.get(c.getName());
                if (node == null) {
                    node = c.isArray() ? OutputUtil.MAPPER.createArrayNode() : OutputUtil.MAPPER.createObjectNode();
                    ((ObjectNode)nested).set(c.getName(), node);
                }
                nested = node;
            }
        }
    }

    private static void setArrayItem(ArrayNode list, int index, JsonNode valNode) {
        if (index == -1) {
            list.add(valNode);
            return;
        }
        for (int i = list.size(); i < index + 1; ++i) {
            list.add(NullNode.instance);
        }
        list.set(index, valNode);
    }

    private static void removeArrayItem(ArrayNode list, int index) {
        if (index == -1) {
            throw new IllegalArgumentException("Internal error - should never be called with index == -1");
        }
        list.remove(index);
    }

    static JsonNode valueToJsonNode(String val) {
        try {
            return OutputUtil.MAPPER.readTree(val);
        }
        catch (Exception exception) {
            if (ReflectionUtil.isQuoted(val)) {
                return TextNode.valueOf(ReflectionUtil.unquote(val));
            }
            return TextNode.valueOf(val);
        }
    }

    private static boolean isQuoted(String val) {
        return val.startsWith("'") || val.startsWith("\"");
    }

    private static String unquote(String val) {
        if (!val.startsWith("'") && !val.startsWith("\"") || !val.endsWith("'") && !val.endsWith("\"")) {
            throw new RuntimeException("Invalid string value: " + val);
        }
        return val.substring(1, val.length() - 1);
    }

    public static void merge(JsonNode source, ObjectNode dest) {
        if (!source.isObject()) {
            throw new RuntimeException("Not a JSON object: " + String.valueOf(source));
        }
        Iterator<Map.Entry<String, JsonNode>> it = ((ObjectNode)source).fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> item = it.next();
            String name = item.getKey();
            JsonNode node = item.getValue();
            JsonNode destNode = dest.get(name);
            if (destNode != null) {
                if (destNode.isObject()) {
                    if (node.isObject()) {
                        ReflectionUtil.merge(node, (ObjectNode)destNode);
                        continue;
                    }
                    throw new RuntimeException("Attribute is of incompatible type - " + name + ": " + String.valueOf(node));
                }
                if (destNode.isArray()) {
                    if (node.isArray()) {
                        dest.set(name, node);
                        continue;
                    }
                    throw new RuntimeException("Attribute is of incompatible type - " + name + ": " + String.valueOf(node));
                }
                dest.set(name, node);
                continue;
            }
            dest.set(name, node);
        }
    }
}

