/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.admin.resource;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.keycloak.authentication.actiontoken.inviteorg.InviteOrgActionToken;
import org.keycloak.common.util.Time;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.storage.adapter.InMemoryUserAdapter;
import org.keycloak.utils.StringUtil;

public class OrganizationInvitationResource {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final OrganizationModel organization;
    private final AdminEventBuilder adminEvent;
    private final int tokenExpiration;

    public OrganizationInvitationResource(KeycloakSession session, OrganizationModel organization, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.organization = organization;
        this.adminEvent = adminEvent.resource(ResourceType.ORGANIZATION_MEMBERSHIP);
        this.tokenExpiration = this.getTokenExpiration();
    }

    public Response inviteUser(String email, String firstName, String lastName) {
        if (StringUtil.isBlank((String)email)) {
            throw ErrorResponse.error("To invite a member you need to provide an email", Response.Status.BAD_REQUEST);
        }
        UserModel user = this.session.users().getUserByEmail(this.realm, email);
        if (user != null) {
            if (this.organization.isMember(user)) {
                throw ErrorResponse.error("User already a member of the organization", Response.Status.CONFLICT);
            }
            return this.sendInvitation(user);
        }
        user = new InMemoryUserAdapter(this.session, this.realm, null);
        user.setEmail(email);
        if (firstName != null && lastName != null) {
            user.setFirstName(firstName);
            user.setLastName(lastName);
        }
        return this.sendInvitation(user);
    }

    public Response inviteExistingUser(String id) {
        if (StringUtil.isBlank((String)id)) {
            throw new BadRequestException("To invite a member you need to provide the user id");
        }
        UserModel user = this.session.users().getUserById(this.realm, id);
        if (user == null) {
            throw ErrorResponse.error("User does not exist", Response.Status.BAD_REQUEST);
        }
        return this.sendInvitation(user);
    }

    private Response sendInvitation(UserModel user) {
        String link = user.getId() == null ? this.createRegistrationLink(user) : this.createInvitationLink(user);
        try {
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setRealm(this.realm).setUser(user).sendOrgInviteEmail(this.organization, link, TimeUnit.SECONDS.toMinutes(this.getActionTokenLifespan()));
        }
        catch (EmailException e) {
            ServicesLogger.LOGGER.failedToSendEmail((Exception)((Object)e));
            throw ErrorResponse.error("Failed to send invite email", Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        return Response.noContent().build();
    }

    private int getTokenExpiration() {
        return Time.currentTime() + this.getActionTokenLifespan();
    }

    private int getActionTokenLifespan() {
        return this.realm.getActionTokenGeneratedByAdminLifespan();
    }

    private String createInvitationLink(UserModel user) {
        return LoginActionsService.actionTokenProcessor((UriInfo)this.session.getContext().getUri()).queryParam("key", new Object[]{this.createToken(user)}).build(new Object[]{this.realm.getName()}).toString();
    }

    private String createRegistrationLink(UserModel user) {
        return OIDCLoginProtocolService.registrationsUrl(this.session.getContext().getUri().getBaseUriBuilder()).queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{"account"}).queryParam("token", new Object[]{this.createToken(user)}).buildFromMap(Map.of("realm", this.realm.getName(), "protocol", "openid-connect")).toString();
    }

    private String createToken(UserModel user) {
        InviteOrgActionToken token = new InviteOrgActionToken(user.getId(), this.tokenExpiration, user.getEmail(), "account");
        token.setOrgId(this.organization.getId());
        if (this.organization.getRedirectUrl() == null || this.organization.getRedirectUrl().isBlank()) {
            token.setRedirectUri(Urls.accountBase(this.session.getContext().getUri().getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString());
        } else {
            token.setRedirectUri(this.organization.getRedirectUrl());
        }
        return token.serialize(this.session, this.realm, (UriInfo)this.session.getContext().getUri());
    }
}

