/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.QualifiedTypeName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.UserDefinedType;

public class AbstractUserDefinedType
implements UserDefinedType {
    private final String contributor;
    private Identifier catalog;
    private Identifier schema;
    private Identifier name;

    public AbstractUserDefinedType(String contributor, Namespace namespace, Identifier physicalTypeName) {
        this.contributor = contributor;
        this.catalog = namespace.getPhysicalName().catalog();
        this.schema = namespace.getPhysicalName().schema();
        this.name = physicalTypeName;
    }

    @Override
    public String getContributor() {
        return this.contributor;
    }

    @Override
    public String getQualifiedName(SqlStringGenerationContext context) {
        return context.format(new QualifiedTypeName(this.catalog, this.schema, this.name));
    }

    public void setName(String name) {
        this.name = Identifier.toIdentifier(name);
    }

    @Override
    public String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getNameIdentifier() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.name == null ? null : this.name.toString();
    }

    @Override
    public String getQuotedName(Dialect dialect) {
        return this.name == null ? null : this.name.render(dialect);
    }

    @Override
    public QualifiedTableName getQualifiedTableName() {
        return this.name == null ? null : new QualifiedTableName(this.catalog, this.schema, this.name);
    }

    @Override
    public boolean isQuoted() {
        return this.name.isQuoted();
    }

    public void setQuoted(boolean quoted) {
        if (quoted == this.name.isQuoted()) {
            return;
        }
        this.name = new Identifier(this.name.getText(), quoted);
    }

    public void setSchema(String schema) {
        this.schema = Identifier.toIdentifier(schema);
    }

    @Override
    public String getSchema() {
        return this.schema == null ? null : this.schema.getText();
    }

    @Override
    public String getQuotedSchema() {
        return this.schema == null ? null : this.schema.toString();
    }

    @Override
    public String getQuotedSchema(Dialect dialect) {
        return this.schema == null ? null : this.schema.render(dialect);
    }

    @Override
    public boolean isSchemaQuoted() {
        return this.schema != null && this.schema.isQuoted();
    }

    public void setCatalog(String catalog) {
        this.catalog = Identifier.toIdentifier(catalog);
    }

    @Override
    public String getCatalog() {
        return this.catalog == null ? null : this.catalog.getText();
    }

    @Override
    public String getQuotedCatalog() {
        return this.catalog == null ? null : this.catalog.render();
    }

    public String getQuotedCatalog(Dialect dialect) {
        return this.catalog == null ? null : this.catalog.render(dialect);
    }

    @Override
    public boolean isCatalogQuoted() {
        return this.catalog != null && this.catalog.isQuoted();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.equals((AbstractUserDefinedType)object);
    }

    public boolean equals(AbstractUserDefinedType table) {
        if (null == table) {
            return false;
        }
        if (this == table) {
            return true;
        }
        return Identifier.areEqual(this.name, table.name) && Identifier.areEqual(this.schema, table.schema) && Identifier.areEqual(this.catalog, table.catalog);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getClass().getSimpleName()).append('(');
        if (this.getCatalog() != null) {
            buf.append(this.getCatalog()).append(".");
        }
        if (this.getSchema() != null) {
            buf.append(this.getSchema()).append(".");
        }
        buf.append(this.getName()).append(')');
        return buf.toString();
    }

    @Override
    public String getExportIdentifier() {
        StringBuilder qualifiedName = new StringBuilder();
        if (this.catalog != null) {
            qualifiedName.append(this.catalog.render()).append('.');
        }
        if (this.schema != null) {
            qualifiedName.append(this.schema.render()).append('.');
        }
        return qualifiedName.append(this.name.render()).toString();
    }
}

