/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import java.net.BindException;

public class QuarkusBindException
extends BindException {
    private final String host;
    private final int port;

    public QuarkusBindException(String host, int port, BindException e) {
        super(QuarkusBindException.createMessage(host, port) + ": " + e.getMessage());
        this.host = host;
        this.port = port;
    }

    private static String createMessage(String host, int port) {
        if (QuarkusBindException.isKnownHost(host)) {
            return "Port already bound: " + port;
        }
        return "Unable to bind to host: " + host + " and port: " + port;
    }

    public static boolean isKnownHost(String host) {
        return "localhost".equals(host) || "127.0.0.1".equals(host) || "0.0.0.0".equals(host);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

