/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.instruction;

import io.github.dmlloyd.classfile.Instruction;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.impl.AbstractInstruction;
import io.github.dmlloyd.classfile.impl.BytecodeHelpers;
import io.github.dmlloyd.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConvertInstruction
extends Instruction {
    public TypeKind fromType();

    public TypeKind toType();

    public static ConvertInstruction of(TypeKind fromType, TypeKind toType) {
        return ConvertInstruction.of(BytecodeHelpers.convertOpcode(fromType, toType));
    }

    public static ConvertInstruction of(Opcode op) {
        Util.checkKind(op, Opcode.Kind.CONVERT);
        return new AbstractInstruction.UnboundConvertInstruction(op);
    }
}

