/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.instruction;

import io.github.dmlloyd.classfile.Instruction;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.MemberRefEntry;
import io.github.dmlloyd.classfile.constantpool.NameAndTypeEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AbstractInstruction;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.MethodTypeDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InvokeInstruction
extends Instruction {
    public MemberRefEntry method();

    public boolean isInterface();

    public int count();

    default public ClassEntry owner() {
        return this.method().owner();
    }

    default public Utf8Entry name() {
        return this.method().nameAndType().name();
    }

    default public Utf8Entry type() {
        return this.method().nameAndType().type();
    }

    default public MethodTypeDesc typeSymbol() {
        return Util.methodTypeSymbol(this.method().type());
    }

    public static InvokeInstruction of(Opcode op, MemberRefEntry method) {
        Util.checkKind(op, Opcode.Kind.INVOKE);
        return new AbstractInstruction.UnboundInvokeInstruction(op, method);
    }

    public static InvokeInstruction of(Opcode op, ClassEntry owner, Utf8Entry name, Utf8Entry type, boolean isInterface) {
        return InvokeInstruction.of(op, owner, TemporaryConstantPool.INSTANCE.nameAndTypeEntry(name, type), isInterface);
    }

    public static InvokeInstruction of(Opcode op, ClassEntry owner, NameAndTypeEntry nameAndType, boolean isInterface) {
        return InvokeInstruction.of(op, isInterface ? TemporaryConstantPool.INSTANCE.interfaceMethodRefEntry(owner, nameAndType) : TemporaryConstantPool.INSTANCE.methodRefEntry(owner, nameAndType));
    }
}

