/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.telemetry.tracing.SpanContext;
import org.opensearch.telemetry.tracing.SpanKind;
import org.opensearch.telemetry.tracing.attributes.Attributes;

@ExperimentalApi
public final class SpanCreationContext {
    private String spanName;
    private Attributes attributes;
    private SpanKind spanKind = SpanKind.INTERNAL;
    private SpanContext parent;

    private SpanCreationContext() {
    }

    public static SpanCreationContext server() {
        SpanCreationContext spanCreationContext = new SpanCreationContext();
        spanCreationContext.spanKind = SpanKind.SERVER;
        return spanCreationContext;
    }

    public static SpanCreationContext client() {
        SpanCreationContext spanCreationContext = new SpanCreationContext();
        spanCreationContext.spanKind = SpanKind.CLIENT;
        return spanCreationContext;
    }

    public static SpanCreationContext internal() {
        SpanCreationContext spanCreationContext = new SpanCreationContext();
        spanCreationContext.spanKind = SpanKind.INTERNAL;
        return spanCreationContext;
    }

    public SpanCreationContext name(String spanName) {
        this.spanName = spanName;
        return this;
    }

    public SpanCreationContext attributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public SpanCreationContext parent(SpanContext parent) {
        this.parent = parent;
        return this;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public SpanKind getSpanKind() {
        return this.spanKind;
    }

    public SpanContext getParent() {
        return this.parent;
    }
}

