"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateReportState = void 0;
var _uiToBackend = require("../utils/converters/uiToBackend");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// The only thing can be updated of a report instance is its "state"
const updateReportState = async (reportId, opensearchReportsClient, state) => {
  //Build request body
  const reqBody = {
    reportInstanceId: reportId,
    status: (0, _uiToBackend.getBackendReportState)(state)
  };
  const opensearchResp = await opensearchReportsClient.callAsInternalUser(
  // @ts-ignore
  'opensearch_reports.updateReportInstanceStatus', {
    reportInstanceId: reportId,
    body: reqBody
  });
  return opensearchResp;
};
exports.updateReportState = updateReportState;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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