/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html.charsetdetector;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.tika.parser.html.charsetdetector.CharsetAliases;

class CharsetDetectionResult {
    private boolean found = false;
    private Charset charset = null;

    private CharsetDetectionResult() {
    }

    static CharsetDetectionResult notFound() {
        return new CharsetDetectionResult();
    }

    public boolean isFound() {
        return this.found;
    }

    public void find(String charsetName) {
        this.found = true;
        if ("x-user-defined".equals(charsetName = charsetName.trim())) {
            charsetName = "windows-1252";
        }
        this.charset = CharsetAliases.getCharsetByLabel(charsetName);
        if (StandardCharsets.UTF_16LE.equals(this.charset) || StandardCharsets.UTF_16BE.equals(this.charset)) {
            this.charset = StandardCharsets.UTF_8;
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.found = true;
        this.charset = charset;
    }
}

