/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.PluginStats;
import org.opensearch.client.opensearch.cluster.stats.ClusterFileSystem;
import org.opensearch.client.opensearch.cluster.stats.ClusterIngest;
import org.opensearch.client.opensearch.cluster.stats.ClusterJvm;
import org.opensearch.client.opensearch.cluster.stats.ClusterNetworkTypes;
import org.opensearch.client.opensearch.cluster.stats.ClusterNodeCount;
import org.opensearch.client.opensearch.cluster.stats.ClusterOperatingSystem;
import org.opensearch.client.opensearch.cluster.stats.ClusterProcess;
import org.opensearch.client.opensearch.cluster.stats.IndexingPressure;
import org.opensearch.client.opensearch.cluster.stats.NodePackagingType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterNodes
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterNodes> {
    @Nullable
    private final ClusterNodeCount count;
    @Nonnull
    private final Map<String, Integer> discoveryTypes;
    @Nullable
    private final ClusterFileSystem fs;
    @Nullable
    private final IndexingPressure indexingPressure;
    @Nullable
    private final ClusterIngest ingest;
    @Nullable
    private final ClusterJvm jvm;
    @Nullable
    private final ClusterNetworkTypes networkTypes;
    @Nullable
    private final ClusterOperatingSystem os;
    @Nonnull
    private final List<NodePackagingType> packagingTypes;
    @Nonnull
    private final List<PluginStats> plugins;
    @Nullable
    private final ClusterProcess process;
    @Nonnull
    private final List<String> versions;
    public static final JsonpDeserializer<ClusterNodes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNodes::setupClusterNodesDeserializer);

    private ClusterNodes(Builder builder) {
        this.count = builder.count;
        this.discoveryTypes = ApiTypeHelper.unmodifiable(builder.discoveryTypes);
        this.fs = builder.fs;
        this.indexingPressure = builder.indexingPressure;
        this.ingest = builder.ingest;
        this.jvm = builder.jvm;
        this.networkTypes = builder.networkTypes;
        this.os = builder.os;
        this.packagingTypes = ApiTypeHelper.unmodifiable(builder.packagingTypes);
        this.plugins = ApiTypeHelper.unmodifiable(builder.plugins);
        this.process = builder.process;
        this.versions = ApiTypeHelper.unmodifiable(builder.versions);
    }

    public static ClusterNodes of(Function<Builder, ObjectBuilder<ClusterNodes>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ClusterNodeCount count() {
        return this.count;
    }

    @Nonnull
    public final Map<String, Integer> discoveryTypes() {
        return this.discoveryTypes;
    }

    @Nullable
    public final ClusterFileSystem fs() {
        return this.fs;
    }

    @Nullable
    public final IndexingPressure indexingPressure() {
        return this.indexingPressure;
    }

    @Nullable
    public final ClusterIngest ingest() {
        return this.ingest;
    }

    @Nullable
    public final ClusterJvm jvm() {
        return this.jvm;
    }

    @Nullable
    public final ClusterNetworkTypes networkTypes() {
        return this.networkTypes;
    }

    @Nullable
    public final ClusterOperatingSystem os() {
        return this.os;
    }

    @Nonnull
    public final List<NodePackagingType> packagingTypes() {
        return this.packagingTypes;
    }

    @Nonnull
    public final List<PluginStats> plugins() {
        return this.plugins;
    }

    @Nullable
    public final ClusterProcess process() {
        return this.process;
    }

    @Nonnull
    public final List<String> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.count != null) {
            generator.writeKey("count");
            this.count.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.discoveryTypes)) {
            generator.writeKey("discovery_types");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> entry : this.discoveryTypes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().intValue());
            }
            generator.writeEnd();
        }
        if (this.fs != null) {
            generator.writeKey("fs");
            this.fs.serialize(generator, mapper);
        }
        if (this.indexingPressure != null) {
            generator.writeKey("indexing_pressure");
            this.indexingPressure.serialize(generator, mapper);
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
        if (this.jvm != null) {
            generator.writeKey("jvm");
            this.jvm.serialize(generator, mapper);
        }
        if (this.networkTypes != null) {
            generator.writeKey("network_types");
            this.networkTypes.serialize(generator, mapper);
        }
        if (this.os != null) {
            generator.writeKey("os");
            this.os.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.packagingTypes)) {
            generator.writeKey("packaging_types");
            generator.writeStartArray();
            for (NodePackagingType nodePackagingType : this.packagingTypes) {
                nodePackagingType.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.plugins)) {
            generator.writeKey("plugins");
            generator.writeStartArray();
            for (PluginStats pluginStats : this.plugins) {
                pluginStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.process != null) {
            generator.writeKey("process");
            this.process.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.versions)) {
            generator.writeKey("versions");
            generator.writeStartArray();
            for (String string : this.versions) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterNodesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, ClusterNodeCount._DESERIALIZER, "count");
        op.add(Builder::discoveryTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "discovery_types");
        op.add(Builder::fs, ClusterFileSystem._DESERIALIZER, "fs");
        op.add(Builder::indexingPressure, IndexingPressure._DESERIALIZER, "indexing_pressure");
        op.add(Builder::ingest, ClusterIngest._DESERIALIZER, "ingest");
        op.add(Builder::jvm, ClusterJvm._DESERIALIZER, "jvm");
        op.add(Builder::networkTypes, ClusterNetworkTypes._DESERIALIZER, "network_types");
        op.add(Builder::os, ClusterOperatingSystem._DESERIALIZER, "os");
        op.add(Builder::packagingTypes, JsonpDeserializer.arrayDeserializer(NodePackagingType._DESERIALIZER), "packaging_types");
        op.add(Builder::plugins, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "plugins");
        op.add(Builder::process, ClusterProcess._DESERIALIZER, "process");
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "versions");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.count);
        result = 31 * result + Objects.hashCode(this.discoveryTypes);
        result = 31 * result + Objects.hashCode(this.fs);
        result = 31 * result + Objects.hashCode(this.indexingPressure);
        result = 31 * result + Objects.hashCode(this.ingest);
        result = 31 * result + Objects.hashCode(this.jvm);
        result = 31 * result + Objects.hashCode(this.networkTypes);
        result = 31 * result + Objects.hashCode(this.os);
        result = 31 * result + Objects.hashCode(this.packagingTypes);
        result = 31 * result + Objects.hashCode(this.plugins);
        result = 31 * result + Objects.hashCode(this.process);
        result = 31 * result + Objects.hashCode(this.versions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterNodes other = (ClusterNodes)o;
        return Objects.equals(this.count, other.count) && Objects.equals(this.discoveryTypes, other.discoveryTypes) && Objects.equals(this.fs, other.fs) && Objects.equals(this.indexingPressure, other.indexingPressure) && Objects.equals(this.ingest, other.ingest) && Objects.equals(this.jvm, other.jvm) && Objects.equals(this.networkTypes, other.networkTypes) && Objects.equals(this.os, other.os) && Objects.equals(this.packagingTypes, other.packagingTypes) && Objects.equals(this.plugins, other.plugins) && Objects.equals(this.process, other.process) && Objects.equals(this.versions, other.versions);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterNodes> {
        @Nullable
        private ClusterNodeCount count;
        @Nullable
        private Map<String, Integer> discoveryTypes;
        @Nullable
        private ClusterFileSystem fs;
        @Nullable
        private IndexingPressure indexingPressure;
        @Nullable
        private ClusterIngest ingest;
        @Nullable
        private ClusterJvm jvm;
        @Nullable
        private ClusterNetworkTypes networkTypes;
        @Nullable
        private ClusterOperatingSystem os;
        @Nullable
        private List<NodePackagingType> packagingTypes;
        @Nullable
        private List<PluginStats> plugins;
        @Nullable
        private ClusterProcess process;
        @Nullable
        private List<String> versions;

        public Builder() {
        }

        private Builder(ClusterNodes o) {
            this.count = o.count;
            this.discoveryTypes = Builder._mapCopy(o.discoveryTypes);
            this.fs = o.fs;
            this.indexingPressure = o.indexingPressure;
            this.ingest = o.ingest;
            this.jvm = o.jvm;
            this.networkTypes = o.networkTypes;
            this.os = o.os;
            this.packagingTypes = Builder._listCopy(o.packagingTypes);
            this.plugins = Builder._listCopy(o.plugins);
            this.process = o.process;
            this.versions = Builder._listCopy(o.versions);
        }

        private Builder(Builder o) {
            this.count = o.count;
            this.discoveryTypes = Builder._mapCopy(o.discoveryTypes);
            this.fs = o.fs;
            this.indexingPressure = o.indexingPressure;
            this.ingest = o.ingest;
            this.jvm = o.jvm;
            this.networkTypes = o.networkTypes;
            this.os = o.os;
            this.packagingTypes = Builder._listCopy(o.packagingTypes);
            this.plugins = Builder._listCopy(o.plugins);
            this.process = o.process;
            this.versions = Builder._listCopy(o.versions);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder count(@Nullable ClusterNodeCount value) {
            this.count = value;
            return this;
        }

        @Nonnull
        public final Builder count(Function<ClusterNodeCount.Builder, ObjectBuilder<ClusterNodeCount>> fn) {
            return this.count(fn.apply(new ClusterNodeCount.Builder()).build());
        }

        @Nonnull
        public final Builder discoveryTypes(Map<String, Integer> map) {
            this.discoveryTypes = Builder._mapPutAll(this.discoveryTypes, map);
            return this;
        }

        @Nonnull
        public final Builder discoveryTypes(String key, Integer value) {
            this.discoveryTypes = Builder._mapPut(this.discoveryTypes, key, value);
            return this;
        }

        @Nonnull
        public final Builder fs(@Nullable ClusterFileSystem value) {
            this.fs = value;
            return this;
        }

        @Nonnull
        public final Builder fs(Function<ClusterFileSystem.Builder, ObjectBuilder<ClusterFileSystem>> fn) {
            return this.fs(fn.apply(new ClusterFileSystem.Builder()).build());
        }

        @Nonnull
        public final Builder indexingPressure(@Nullable IndexingPressure value) {
            this.indexingPressure = value;
            return this;
        }

        @Nonnull
        public final Builder indexingPressure(Function<IndexingPressure.Builder, ObjectBuilder<IndexingPressure>> fn) {
            return this.indexingPressure(fn.apply(new IndexingPressure.Builder()).build());
        }

        @Nonnull
        public final Builder ingest(@Nullable ClusterIngest value) {
            this.ingest = value;
            return this;
        }

        @Nonnull
        public final Builder ingest(Function<ClusterIngest.Builder, ObjectBuilder<ClusterIngest>> fn) {
            return this.ingest(fn.apply(new ClusterIngest.Builder()).build());
        }

        @Nonnull
        public final Builder jvm(@Nullable ClusterJvm value) {
            this.jvm = value;
            return this;
        }

        @Nonnull
        public final Builder jvm(Function<ClusterJvm.Builder, ObjectBuilder<ClusterJvm>> fn) {
            return this.jvm(fn.apply(new ClusterJvm.Builder()).build());
        }

        @Nonnull
        public final Builder networkTypes(@Nullable ClusterNetworkTypes value) {
            this.networkTypes = value;
            return this;
        }

        @Nonnull
        public final Builder networkTypes(Function<ClusterNetworkTypes.Builder, ObjectBuilder<ClusterNetworkTypes>> fn) {
            return this.networkTypes(fn.apply(new ClusterNetworkTypes.Builder()).build());
        }

        @Nonnull
        public final Builder os(@Nullable ClusterOperatingSystem value) {
            this.os = value;
            return this;
        }

        @Nonnull
        public final Builder os(Function<ClusterOperatingSystem.Builder, ObjectBuilder<ClusterOperatingSystem>> fn) {
            return this.os(fn.apply(new ClusterOperatingSystem.Builder()).build());
        }

        @Nonnull
        public final Builder packagingTypes(List<NodePackagingType> list) {
            this.packagingTypes = Builder._listAddAll(this.packagingTypes, list);
            return this;
        }

        @Nonnull
        public final Builder packagingTypes(NodePackagingType value, NodePackagingType ... values) {
            this.packagingTypes = Builder._listAdd(this.packagingTypes, value, values);
            return this;
        }

        @Nonnull
        public final Builder packagingTypes(Function<NodePackagingType.Builder, ObjectBuilder<NodePackagingType>> fn) {
            return this.packagingTypes(fn.apply(new NodePackagingType.Builder()).build(), new NodePackagingType[0]);
        }

        @Nonnull
        public final Builder plugins(List<PluginStats> list) {
            this.plugins = Builder._listAddAll(this.plugins, list);
            return this;
        }

        @Nonnull
        public final Builder plugins(PluginStats value, PluginStats ... values) {
            this.plugins = Builder._listAdd(this.plugins, value, values);
            return this;
        }

        @Nonnull
        public final Builder plugins(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.plugins(fn.apply(new PluginStats.Builder()).build(), new PluginStats[0]);
        }

        @Nonnull
        public final Builder process(@Nullable ClusterProcess value) {
            this.process = value;
            return this;
        }

        @Nonnull
        public final Builder process(Function<ClusterProcess.Builder, ObjectBuilder<ClusterProcess>> fn) {
            return this.process(fn.apply(new ClusterProcess.Builder()).build());
        }

        @Nonnull
        public final Builder versions(List<String> list) {
            this.versions = Builder._listAddAll(this.versions, list);
            return this;
        }

        @Nonnull
        public final Builder versions(String value, String ... values) {
            this.versions = Builder._listAdd(this.versions, value, values);
            return this;
        }

        @Override
        @Nonnull
        public ClusterNodes build() {
            this._checkSingleUse();
            return new ClusterNodes(this);
        }
    }
}

