/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.stats.ClusterOperatingSystemArchitecture;
import org.opensearch.client.opensearch.cluster.stats.ClusterOperatingSystemName;
import org.opensearch.client.opensearch.cluster.stats.ClusterOperatingSystemPrettyName;
import org.opensearch.client.opensearch.cluster.stats.OperatingSystemMemoryInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterOperatingSystem
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterOperatingSystem> {
    private final int allocatedProcessors;
    @Nonnull
    private final List<ClusterOperatingSystemArchitecture> architectures;
    private final int availableProcessors;
    @Nonnull
    private final OperatingSystemMemoryInfo mem;
    @Nonnull
    private final List<ClusterOperatingSystemName> names;
    @Nonnull
    private final List<ClusterOperatingSystemPrettyName> prettyNames;
    public static final JsonpDeserializer<ClusterOperatingSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterOperatingSystem::setupClusterOperatingSystemDeserializer);

    private ClusterOperatingSystem(Builder builder) {
        this.allocatedProcessors = ApiTypeHelper.requireNonNull(builder.allocatedProcessors, this, "allocatedProcessors");
        this.architectures = ApiTypeHelper.unmodifiable(builder.architectures);
        this.availableProcessors = ApiTypeHelper.requireNonNull(builder.availableProcessors, this, "availableProcessors");
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.prettyNames = ApiTypeHelper.unmodifiableRequired(builder.prettyNames, (Object)this, "prettyNames");
    }

    public static ClusterOperatingSystem of(Function<Builder, ObjectBuilder<ClusterOperatingSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int allocatedProcessors() {
        return this.allocatedProcessors;
    }

    @Nonnull
    public final List<ClusterOperatingSystemArchitecture> architectures() {
        return this.architectures;
    }

    public final int availableProcessors() {
        return this.availableProcessors;
    }

    @Nonnull
    public final OperatingSystemMemoryInfo mem() {
        return this.mem;
    }

    @Nonnull
    public final List<ClusterOperatingSystemName> names() {
        return this.names;
    }

    @Nonnull
    public final List<ClusterOperatingSystemPrettyName> prettyNames() {
        return this.prettyNames;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocated_processors");
        generator.write(this.allocatedProcessors);
        if (ApiTypeHelper.isDefined(this.architectures)) {
            generator.writeKey("architectures");
            generator.writeStartArray();
            for (ClusterOperatingSystemArchitecture clusterOperatingSystemArchitecture : this.architectures) {
                clusterOperatingSystemArchitecture.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("available_processors");
        generator.write(this.availableProcessors);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("names");
        generator.writeStartArray();
        for (ClusterOperatingSystemName clusterOperatingSystemName : this.names) {
            clusterOperatingSystemName.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("pretty_names");
        generator.writeStartArray();
        for (ClusterOperatingSystemPrettyName clusterOperatingSystemPrettyName : this.prettyNames) {
            clusterOperatingSystemPrettyName.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterOperatingSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocatedProcessors, JsonpDeserializer.integerDeserializer(), "allocated_processors");
        op.add(Builder::architectures, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemArchitecture._DESERIALIZER), "architectures");
        op.add(Builder::availableProcessors, JsonpDeserializer.integerDeserializer(), "available_processors");
        op.add(Builder::mem, OperatingSystemMemoryInfo._DESERIALIZER, "mem");
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemName._DESERIALIZER), "names");
        op.add(Builder::prettyNames, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemPrettyName._DESERIALIZER), "pretty_names");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.allocatedProcessors);
        result = 31 * result + Objects.hashCode(this.architectures);
        result = 31 * result + Integer.hashCode(this.availableProcessors);
        result = 31 * result + this.mem.hashCode();
        result = 31 * result + this.names.hashCode();
        result = 31 * result + this.prettyNames.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterOperatingSystem other = (ClusterOperatingSystem)o;
        return this.allocatedProcessors == other.allocatedProcessors && Objects.equals(this.architectures, other.architectures) && this.availableProcessors == other.availableProcessors && this.mem.equals(other.mem) && this.names.equals(other.names) && this.prettyNames.equals(other.prettyNames);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterOperatingSystem> {
        private Integer allocatedProcessors;
        @Nullable
        private List<ClusterOperatingSystemArchitecture> architectures;
        private Integer availableProcessors;
        private OperatingSystemMemoryInfo mem;
        private List<ClusterOperatingSystemName> names;
        private List<ClusterOperatingSystemPrettyName> prettyNames;

        public Builder() {
        }

        private Builder(ClusterOperatingSystem o) {
            this.allocatedProcessors = o.allocatedProcessors;
            this.architectures = Builder._listCopy(o.architectures);
            this.availableProcessors = o.availableProcessors;
            this.mem = o.mem;
            this.names = Builder._listCopy(o.names);
            this.prettyNames = Builder._listCopy(o.prettyNames);
        }

        private Builder(Builder o) {
            this.allocatedProcessors = o.allocatedProcessors;
            this.architectures = Builder._listCopy(o.architectures);
            this.availableProcessors = o.availableProcessors;
            this.mem = o.mem;
            this.names = Builder._listCopy(o.names);
            this.prettyNames = Builder._listCopy(o.prettyNames);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allocatedProcessors(int value) {
            this.allocatedProcessors = value;
            return this;
        }

        @Nonnull
        public final Builder architectures(List<ClusterOperatingSystemArchitecture> list) {
            this.architectures = Builder._listAddAll(this.architectures, list);
            return this;
        }

        @Nonnull
        public final Builder architectures(ClusterOperatingSystemArchitecture value, ClusterOperatingSystemArchitecture ... values) {
            this.architectures = Builder._listAdd(this.architectures, value, values);
            return this;
        }

        @Nonnull
        public final Builder architectures(Function<ClusterOperatingSystemArchitecture.Builder, ObjectBuilder<ClusterOperatingSystemArchitecture>> fn) {
            return this.architectures(fn.apply(new ClusterOperatingSystemArchitecture.Builder()).build(), new ClusterOperatingSystemArchitecture[0]);
        }

        @Nonnull
        public final Builder availableProcessors(int value) {
            this.availableProcessors = value;
            return this;
        }

        @Nonnull
        public final Builder mem(OperatingSystemMemoryInfo value) {
            this.mem = value;
            return this;
        }

        @Nonnull
        public final Builder mem(Function<OperatingSystemMemoryInfo.Builder, ObjectBuilder<OperatingSystemMemoryInfo>> fn) {
            return this.mem(fn.apply(new OperatingSystemMemoryInfo.Builder()).build());
        }

        @Nonnull
        public final Builder names(List<ClusterOperatingSystemName> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        @Nonnull
        public final Builder names(ClusterOperatingSystemName value, ClusterOperatingSystemName ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        @Nonnull
        public final Builder names(Function<ClusterOperatingSystemName.Builder, ObjectBuilder<ClusterOperatingSystemName>> fn) {
            return this.names(fn.apply(new ClusterOperatingSystemName.Builder()).build(), new ClusterOperatingSystemName[0]);
        }

        @Nonnull
        public final Builder prettyNames(List<ClusterOperatingSystemPrettyName> list) {
            this.prettyNames = Builder._listAddAll(this.prettyNames, list);
            return this;
        }

        @Nonnull
        public final Builder prettyNames(ClusterOperatingSystemPrettyName value, ClusterOperatingSystemPrettyName ... values) {
            this.prettyNames = Builder._listAdd(this.prettyNames, value, values);
            return this;
        }

        @Nonnull
        public final Builder prettyNames(Function<ClusterOperatingSystemPrettyName.Builder, ObjectBuilder<ClusterOperatingSystemPrettyName>> fn) {
            return this.prettyNames(fn.apply(new ClusterOperatingSystemPrettyName.Builder()).build(), new ClusterOperatingSystemPrettyName[0]);
        }

        @Override
        @Nonnull
        public ClusterOperatingSystem build() {
            this._checkSingleUse();
            return new ClusterOperatingSystem(this);
        }
    }
}

