/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import com.topografix.gpx._1._0.Gpx;
import com.topografix.gpx._1._0.ObjectFactory;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSAltitude;
import org.fibs.geotag.data.UpdateGPSLatitude;
import org.fibs.geotag.data.UpdateGPSLongitude;
import org.fibs.geotag.track.TrackStore;
import org.fibs.geotag.util.Units;
import org.fibs.geotag.util.Util;

public class TrackMatcher {
    private int matchesPerformed = 0;
    private double totalTime = 0.0;
    private int startIndex = 0;

    public Match findMatch(Calendar timeGMT) {
        if (!TrackStore.getTrackStore().hasTracks()) {
            return null;
        }
        ObjectFactory objectFactory = new ObjectFactory();
        Gpx.Trk.Trkseg.Trkpt searchKey = objectFactory.createGpxTrkTrksegTrkpt();
        XMLGregorianCalendar xmlTimeGMT = null;
        try {
            xmlTimeGMT = DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)timeGMT);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        searchKey.setTime(xmlTimeGMT);
        long start = System.currentTimeMillis();
        Match match = new Match();
        Gpx.Trk.Trkseg.Trkpt lastPointBefore = null;
        GregorianCalendar lastPointBeforeTime = null;
        Gpx.Trk.Trkseg.Trkpt firstPointAfter = null;
        List<Gpx.Trk.Trkseg> trackSegments = TrackStore.getTrackStore().getTrackSegments();
        int segmentIndex = this.startIndex;
        while (segmentIndex < trackSegments.size()) {
            int greaterOrEqual;
            Gpx.Trk.Trkseg segment = trackSegments.get(segmentIndex);
            List<Gpx.Trk.Trkseg.Trkpt> trackPoints = segment.getTrkpt();
            if (trackPoints.size() > 1 && match.getMatchingSegment() == null && (greaterOrEqual = Collections.binarySearch(trackPoints, searchKey, new TrackPointComparator())) != -1 && greaterOrEqual != -trackPoints.size() - 1) {
                this.startIndex = segmentIndex;
                if (greaterOrEqual < 0) {
                    greaterOrEqual = -(greaterOrEqual + 1);
                } else if (greaterOrEqual == 0) {
                    greaterOrEqual = 1;
                }
                match.setMatchingSegment(segment);
                match.setPreviousPoint(trackPoints.get(greaterOrEqual - 1));
                match.setNextPoint(trackPoints.get(greaterOrEqual));
            }
            if (match.getMatchingSegment() == null && trackPoints.size() > 0) {
                Gpx.Trk.Trkseg.Trkpt startPoint = trackPoints.get(0);
                Gpx.Trk.Trkseg.Trkpt endPoint = trackPoints.get(trackPoints.size() - 1);
                GregorianCalendar startTime = startPoint.getTime().toGregorianCalendar();
                GregorianCalendar endTime = endPoint.getTime().toGregorianCalendar();
                if (startTime.compareTo(timeGMT) >= 0) {
                    firstPointAfter = startPoint;
                    break;
                }
                if (endTime.compareTo(timeGMT) <= 0) {
                    if (lastPointBefore == null || lastPointBeforeTime == null || lastPointBeforeTime.before(endTime)) {
                        lastPointBefore = endPoint;
                        lastPointBeforeTime = endTime;
                    }
                    this.startIndex = segmentIndex;
                }
            }
            ++segmentIndex;
        }
        long end = System.currentTimeMillis();
        ++this.matchesPerformed;
        this.totalTime += (double)(end - start) / 1000.0;
        if (match.getMatchingSegment() != null) {
            return match;
        }
        if (lastPointBefore != null && firstPointAfter != null) {
            match.setPreviousPoint(lastPointBefore);
            match.setNextPoint(firstPointAfter);
            return match;
        }
        return null;
    }

    public void performMatch(ImageInfo imageInfo, Match match) {
        boolean update;
        Gpx.Trk.Trkseg.Trkpt startPoint = match.getPreviousPoint();
        Gpx.Trk.Trkseg.Trkpt endPoint = match.getNextPoint();
        GregorianCalendar startTime = startPoint.getTime().toGregorianCalendar();
        GregorianCalendar endTime = endPoint.getTime().toGregorianCalendar();
        double ratio = Util.calculateRatio(startTime.getTimeInMillis(), imageInfo.getTimeGMT().getTimeInMillis(), endTime.getTimeInMillis());
        double startLatitude = startPoint.getLat().doubleValue();
        double startLongitude = startPoint.getLon().doubleValue();
        double startAltitude = 0.0;
        if (startPoint.getEle() != null) {
            startAltitude = startPoint.getEle().doubleValue();
        }
        double endLatitude = endPoint.getLat().doubleValue();
        double endLongitude = endPoint.getLon().doubleValue();
        double endAltitude = 0.0;
        if (endPoint.getEle() != null) {
            endAltitude = endPoint.getEle().doubleValue();
        }
        double latitude = Util.applyRatio(startLatitude, endLatitude, ratio);
        double longitude = Util.applyRatio(startLongitude, endLongitude, ratio);
        double altitude = Util.applyRatio(startAltitude, endAltitude, ratio);
        boolean bl = update = imageInfo.getSource() != ImageInfo.DATA_SOURCE.IMAGE;
        if (!update) {
            try {
                double oldLatitude = Double.parseDouble(imageInfo.getGpsLatitude());
                double oldLongitude = Double.parseDouble(imageInfo.getGpsLongitude());
                double distance = Util.greatCircleDistance(latitude, longitude, oldLatitude, oldLongitude);
                if (distance > 1.0) {
                    update = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                update = true;
            }
        }
        if (update) {
            new UpdateGPSLatitude(imageInfo, Double.toString(latitude), ImageInfo.DATA_SOURCE.TRACK);
            new UpdateGPSLongitude(imageInfo, Double.toString(longitude), ImageInfo.DATA_SOURCE.TRACK);
            new UpdateGPSAltitude(imageInfo, Double.toString(altitude), ImageInfo.DATA_SOURCE.TRACK, Units.ALTITUDE.METRES);
        }
    }

    public static class Match {
        private Gpx.Trk.Trkseg matchingSegment;
        private Gpx.Trk.Trkseg.Trkpt previousPoint;
        private Gpx.Trk.Trkseg.Trkpt nextPoint;

        public Gpx.Trk.Trkseg getMatchingSegment() {
            return this.matchingSegment;
        }

        public void setMatchingSegment(Gpx.Trk.Trkseg matchingSegment) {
            this.matchingSegment = matchingSegment;
        }

        public Gpx.Trk.Trkseg.Trkpt getPreviousPoint() {
            return this.previousPoint;
        }

        public void setPreviousPoint(Gpx.Trk.Trkseg.Trkpt previousPoint) {
            this.previousPoint = previousPoint;
        }

        public Gpx.Trk.Trkseg.Trkpt getNextPoint() {
            return this.nextPoint;
        }

        public void setNextPoint(Gpx.Trk.Trkseg.Trkpt nextPoint) {
            this.nextPoint = nextPoint;
        }
    }

    static class TrackPointComparator
    implements Comparator<Gpx.Trk.Trkseg.Trkpt>,
    Serializable {
        private static final long serialVersionUID = 1L;

        TrackPointComparator() {
        }

        @Override
        public int compare(Gpx.Trk.Trkseg.Trkpt point1, Gpx.Trk.Trkseg.Trkpt point2) {
            GregorianCalendar time1 = point1.getTime().toGregorianCalendar();
            GregorianCalendar time2 = point2.getTime().toGregorianCalendar();
            return time1.compareTo(time2);
        }
    }
}

