/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorInt16
extends AbstractList<Short>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorInt16(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorInt16 vectorInt16) {
        return vectorInt16 == null ? 0L : vectorInt16.swigCPtr;
    }

    protected static long swigRelease(VectorInt16 vectorInt16) {
        long l = 0L;
        if (vectorInt16 != null) {
            if (!vectorInt16.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorInt16.swigCPtr;
            vectorInt16.swigCMemOwn = false;
            vectorInt16.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorInt16(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorInt16(short[] sArray) {
        this();
        this.reserve(sArray.length);
        for (short s : sArray) {
            this.add(s);
        }
    }

    public VectorInt16(Iterable<Short> iterable) {
        this();
        for (short s : iterable) {
            this.add(s);
        }
    }

    @Override
    public Short get(int n) {
        return this.doGet(n);
    }

    @Override
    public Short set(int n, Short s) {
        return this.doSet(n, s);
    }

    @Override
    public boolean add(Short s) {
        ++this.modCount;
        this.doAdd(s);
        return true;
    }

    @Override
    public void add(int n, Short s) {
        ++this.modCount;
        this.doAdd(n, s);
    }

    @Override
    public Short remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorInt16() {
        this(SimpleITKJNI.new_VectorInt16__SWIG_0(), true);
    }

    public VectorInt16(VectorInt16 vectorInt16) {
        this(SimpleITKJNI.new_VectorInt16__SWIG_1(VectorInt16.getCPtr(vectorInt16), vectorInt16), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorInt16_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorInt16_clear(this.swigCPtr, this);
    }

    public VectorInt16(int n, short s) {
        this(SimpleITKJNI.new_VectorInt16__SWIG_2(n, s), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorInt16_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorInt16_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorInt16_doSize(this.swigCPtr, this);
    }

    private void doAdd(short s) {
        SimpleITKJNI.VectorInt16_doAdd__SWIG_0(this.swigCPtr, this, s);
    }

    private void doAdd(int n, short s) {
        SimpleITKJNI.VectorInt16_doAdd__SWIG_1(this.swigCPtr, this, n, s);
    }

    private short doRemove(int n) {
        return SimpleITKJNI.VectorInt16_doRemove(this.swigCPtr, this, n);
    }

    private short doGet(int n) {
        return SimpleITKJNI.VectorInt16_doGet(this.swigCPtr, this, n);
    }

    private short doSet(int n, short s) {
        return SimpleITKJNI.VectorInt16_doSet(this.swigCPtr, this, n, s);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorInt16_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

