/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

binary reconstruction by erosion of an image


Reconstruction by erosion operates on a "marker" image and a
"mask" image, and is defined as the erosion of the marker image with
respect to the mask image iterated until stability.

Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book "Morphological Image Analysis: Principles and Applications",
Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


See:
 MorphologyImageFilter , ReconstructionByErosionImageFilter , BinaryReconstructionByDilationImageFilter

 itk::simple::BinaryReconstructionByErosion for the procedural interface

 itk::BinaryReconstructionByErosionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryReconstructionByErosionImageFilter.h
*/
public class BinaryReconstructionByErosionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryReconstructionByErosionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryReconstructionByErosionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryReconstructionByErosionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryReconstructionByErosionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryReconstructionByErosionImageFilter::~BinaryReconstructionByErosionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryReconstructionByErosionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryReconstructionByErosionImageFilter::BinaryReconstructionByErosionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryReconstructionByErosionImageFilter() {
    this(SimpleITKJNI.new_BinaryReconstructionByErosionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByErosionImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryReconstructionByErosionImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryReconstructionByErosionImageFilter::GetBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryReconstructionByErosionImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByErosionImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::max() .

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryReconstructionByErosionImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryReconstructionByErosionImageFilter::GetForegroundValue() const

Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::max() .

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryReconstructionByErosionImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByErosionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.BinaryReconstructionByErosionImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByErosionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.BinaryReconstructionByErosionImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryReconstructionByErosionImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.BinaryReconstructionByErosionImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryReconstructionByErosionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.BinaryReconstructionByErosionImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryReconstructionByErosionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryReconstructionByErosionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryReconstructionByErosionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryReconstructionByErosionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryReconstructionByErosionImageFilter::Execute(const Image &amp;markerImage, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image markerImage, Image maskImage) {
    return new Image(SimpleITKJNI.BinaryReconstructionByErosionImageFilter_execute(swigCPtr, this, Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage), true);
  }

}
