/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Base class for computing IIR convolution with an approximation of a
Gaussian kernel.


\\[ \\frac{ 1 }{ \\sigma \\sqrt{ 2 \\pi } } \\exp{
\\left( - \\frac{x^2}{ 2 \\sigma^2 } \\right) } \\]

RecursiveGaussianImageFilter is the base class for recursive filters that approximate convolution
with the Gaussian kernel. This class implements the recursive
filtering method proposed by R.Deriche in IEEE-PAMI Vol.12, No.1,
January 1990, pp 78-87, "Fast Algorithms for Low-Level Vision"

Details of the implementation are described in the technical report: R.
Deriche, "Recursively Implementing The Gaussian and Its
Derivatives", INRIA, 1993, ftp://ftp.inria.fr/INRIA/tech-reports/RR/RR-1893.ps.gz

Further improvements of the algorithm are described in: G. Farnebäck
&amp; C.-F. Westin, "Improving Deriche-style Recursive Gaussian
Filters". J Math Imaging Vis 26, 293–299 (2006). https://doi.org/10.1007/s10851-006-8464-z

As compared to itk::DiscreteGaussianImageFilter , this filter tends to be faster for large kernels, and it can take
the derivative of the blurred image in one step. Also, note that we
have itk::RecursiveGaussianImageFilter::SetSigma() , but itk::DiscreteGaussianImageFilter::SetVariance() .


See:
 DiscreteGaussianImageFilter

 itk::simple::RecursiveGaussian for the procedural interface

 itk::RecursiveGaussianImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRecursiveGaussianImageFilter.h
*/
public class RecursiveGaussianImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RecursiveGaussianImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RecursiveGaussianImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RecursiveGaussianImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RecursiveGaussianImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RecursiveGaussianImageFilter::~RecursiveGaussianImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RecursiveGaussianImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RecursiveGaussianImageFilter::RecursiveGaussianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RecursiveGaussianImageFilter() {
    this(SimpleITKJNI.new_RecursiveGaussianImageFilter(), true);
  }

  /**
Self&amp; itk::simple::RecursiveGaussianImageFilter::SetSigma(double Sigma)

Set/Get the Sigma, measured in world coordinates, of the Gaussian
kernel. The default is 1.0. An exception will be generated if the
Sigma value is less than or equal to zero.

*/
public  void setSigma(double Sigma) {
    SimpleITKJNI.RecursiveGaussianImageFilter_setSigma(swigCPtr, this, Sigma);
  }

  /**
double itk::simple::RecursiveGaussianImageFilter::GetSigma() const

Set/Get the Sigma, measured in world coordinates, of the Gaussian
kernel. The default is 1.0. An exception will be generated if the
Sigma value is less than or equal to zero.

*/
public  double getSigma() {
    return SimpleITKJNI.RecursiveGaussianImageFilter_getSigma(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RecursiveGaussianImageFilter::SetNormalizeAcrossScale(bool NormalizeAcrossScale)

     Set/Get the flag for normalizing the gaussian over scale-space.

This flag enables the analysis of the differential shape of features
independent of their size ( both pixels and physical size ). Following
the notation of Tony Lindeberg:

Let \\[ L(x; t) = g(x; t) \\ast f(x) \\] be the scale-space representation of image \\[ f(x) \\] where \\[ g(x; t) = \\frac{1}{ \\sqrt{ 2 \\pi t} } \\exp{
\\left( -\\frac{x^2}{ 2 t } \\right) } \\] is the Gaussian function and \\[\\ast\\] denotes convolution. This is a change from above with \\[ t = \\sigma^2 \\] .

Then the normalized derivative operator for normalized coordinates
across scale is:

\\[ \\partial_\\xi = \\sqrt{t} \\partial_x \\]

The resulting scaling factor is \\[ \\sigma^N \\] where N is the order of the derivative.

When this flag is ON the filter will be normalized in such a way that
the values of derivatives are not biased by the size of the object.
That is to say the maximum value a feature reaches across scale is
independent of the scale of the object.

For analyzing an image across scale-space you want to enable this
flag. It is disabled by default.


Not all scale space axioms are satisfied by this filter, some are only
approximated. Particularly, at fine scales ( say less than 1 pixel )
other methods such as a discrete Gaussian kernel should be considered.


*/
public  void setNormalizeAcrossScale(boolean NormalizeAcrossScale) {
    SimpleITKJNI.RecursiveGaussianImageFilter_setNormalizeAcrossScale(swigCPtr, this, NormalizeAcrossScale);
  }

  /**
Self&amp; itk::simple::RecursiveGaussianImageFilter::NormalizeAcrossScaleOn()

Set the value of NormalizeAcrossScale to true or false respectfully.

*/
public  void normalizeAcrossScaleOn() {
    SimpleITKJNI.RecursiveGaussianImageFilter_normalizeAcrossScaleOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RecursiveGaussianImageFilter::NormalizeAcrossScaleOff()
*/
public  void normalizeAcrossScaleOff() {
    SimpleITKJNI.RecursiveGaussianImageFilter_normalizeAcrossScaleOff(swigCPtr, this);
  }

  /**
bool itk::simple::RecursiveGaussianImageFilter::GetNormalizeAcrossScale() const
*/
public  boolean getNormalizeAcrossScale() {
    return SimpleITKJNI.RecursiveGaussianImageFilter_getNormalizeAcrossScale(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RecursiveGaussianImageFilter::SetOrder(OrderType Order)

     Set/Get the Order of the Gaussian to convolve with.


ZeroOrder is equivalent to convolving with a Gaussian. This is the
default.

FirstOrder is equivalent to convolving with the first derivative of a
Gaussian.

SecondOrder is equivalent to convolving with the second derivative of
a Gaussian.


*/
public  void setOrder(RecursiveGaussianImageFilter.OrderType Order) {
    SimpleITKJNI.RecursiveGaussianImageFilter_setOrder(swigCPtr, this, Order.swigValue());
  }

  /**
OrderType itk::simple::RecursiveGaussianImageFilter::GetOrder() const

     Set/Get the Order of the Gaussian to convolve with.


ZeroOrder is equivalent to convolving with a Gaussian. This is the
default.

FirstOrder is equivalent to convolving with the first derivative of a
Gaussian.

SecondOrder is equivalent to convolving with the second derivative of
a Gaussian.


*/
public  RecursiveGaussianImageFilter.OrderType getOrder() {
    return RecursiveGaussianImageFilter.OrderType.swigToEnum(SimpleITKJNI.RecursiveGaussianImageFilter_getOrder(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::RecursiveGaussianImageFilter::SetDirection(unsigned int Direction)
*/
public  void setDirection(long Direction) {
    SimpleITKJNI.RecursiveGaussianImageFilter_setDirection(swigCPtr, this, Direction);
  }

  /**
unsigned int itk::simple::RecursiveGaussianImageFilter::GetDirection() const
*/
public  long getDirection() {
    return SimpleITKJNI.RecursiveGaussianImageFilter_getDirection(swigCPtr, this);
  }

  /**
std::string itk::simple::RecursiveGaussianImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RecursiveGaussianImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RecursiveGaussianImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RecursiveGaussianImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RecursiveGaussianImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RecursiveGaussianImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  public final static class OrderType {
    public final static RecursiveGaussianImageFilter.OrderType ZeroOrder = new RecursiveGaussianImageFilter.OrderType("ZeroOrder");
    public final static RecursiveGaussianImageFilter.OrderType FirstOrder = new RecursiveGaussianImageFilter.OrderType("FirstOrder");
    public final static RecursiveGaussianImageFilter.OrderType SecondOrder = new RecursiveGaussianImageFilter.OrderType("SecondOrder");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OrderType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OrderType.class + " with value " + swigValue);
    }

    private OrderType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OrderType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OrderType(String swigName, OrderType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OrderType[] swigValues = { ZeroOrder, FirstOrder, SecondOrder };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
