/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.RemoteRuleFilters;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleTest;
import org.languagetool.rules.patterns.RuleIdValidator;

public class RemoteRuleFilterTest
extends PatternRuleTest {
    @Override
    protected List<String> getGrammarFileNames(Language lang) {
        return Collections.singletonList(RemoteRuleFilters.getFilename((Language)lang));
    }

    @Override
    protected void validateRuleIds(Language lang, JLanguageTool lt) {
        List rules = RemoteRuleFilters.load((Language)lang).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        HashSet<String> categoryIds = new HashSet<String>();
        new RuleIdValidator(lang).validateUniqueness();
        for (Rule rule : rules) {
            Category category;
            String catId;
            try {
                Pattern.compile(rule.getId());
            }
            catch (PatternSyntaxException e) {
                Assert.fail((String)("Remote rule filter ID must be a valid regex; got " + rule.getId() + ": " + e));
            }
            if (rule.getId().equalsIgnoreCase("ID")) {
                System.err.println("WARNING: " + lang.getShortCodeWithCountryAndVariant() + " has a rule with id 'ID', this should probably be changed");
            }
            if ((catId = (category = rule.getCategory()).getId().toString()).matches("[A-Z0-9_-]+") || categoryIds.contains(catId)) continue;
            System.err.println("WARNING: category id '" + catId + "' doesn't match expected regexp [A-Z0-9_-]+");
            categoryIds.add(catId);
        }
    }

    @Override
    public void runTestForLanguage(Language lang) throws IOException {
        System.out.println("Running remote rule filter tests for " + lang.getName() + "... ");
        MultiThreadedJLanguageTool lt = RemoteRuleFilterTest.createToolForTesting(lang);
        List<AbstractPatternRule> rules = RemoteRuleFilters.load((Language)lang).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        MultiThreadedJLanguageTool allRulesLt = new MultiThreadedJLanguageTool(lang);
        allRulesLt.disableRules(allRulesLt.getAllRules().stream().map(Rule::getId).collect(Collectors.toList()));
        rules.forEach(arg_0 -> ((MultiThreadedJLanguageTool)allRulesLt).addRule(arg_0));
        this.validateRuleIds(lang, (JLanguageTool)allRulesLt);
        this.validateSentenceStartNotInMarker((JLanguageTool)allRulesLt);
        this.testRegexSyntax(lang, rules);
        this.testGrammarRulesFromXML(rules, (JLanguageTool)allRulesLt, lang);
        System.out.println(rules.size() + " rules tested.");
        allRulesLt.shutdown();
        lt.shutdown();
    }
}

