/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class VariablesImpl {
    public static Map<String, Object> loadVariablesFromPreferenceStore(String packageName, boolean userSpecific) throws IOException {
        if (InstallRegistry.isNoPreferences()) {
            return null;
        }
        try {
            PreferencesUtil.getRootNode(userSpecific).sync();
            Preferences packageNode = PreferencesUtil.getPackageNodeNoCreation(packageName, userSpecific);
            if (packageNode == null) {
                return null;
            }
            packageNode.sync();
            String[] keys2 = packageNode.keys();
            if (keys2 == null || keys2.length == 0) {
                return null;
            }
            HashMap<String, String> encodedVariables = new HashMap<String, String>();
            for (String key : keys2) {
                encodedVariables.put(key, packageNode.get(key, null));
            }
            return VariableEncoding.decodeVariables(encodedVariables, false);
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }

    public static void saveVariablesToPreferenceStore(Map<String, Object> variables, String packageName, boolean userSpecific) throws IOException {
        if (InstallRegistry.isNoPreferences()) {
            return;
        }
        HashMap<String, String> encodedVariables = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String variableName = entry.getKey();
            Object variableValue = entry.getValue();
            VariableEncoding.encodeVariable(encodedVariables, variableName, variableValue);
        }
        try {
            Preferences packageNode = PreferencesUtil.getPackageNode(packageName, userSpecific);
            for (Map.Entry entry : encodedVariables.entrySet()) {
                packageNode.put((String)entry.getKey(), (String)entry.getValue());
            }
            packageNode.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }

    public static Map<String, Object> readInstallerVariables(File responseFile) {
        Map<String, Object> map;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(responseFile));
        try {
            Properties properties = new Properties();
            properties.load(in);
            HashMap<String, String> encodedVariables = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                encodedVariables.put((String)entry.getKey(), (String)entry.getValue());
            }
            map = VariableEncoding.decodeVariables(encodedVariables, true);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return new HashMap<String, Object>();
            }
        }
        ((InputStream)in).close();
        return map;
    }
}

